/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector4f;

public abstract class AbstractVignetteEffect
extends TempEffect {
    public AbstractVignetteEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    protected abstract ResourceLocation getTexture();

    protected abstract Vector4f getColor(float var1);

    protected void setupRender(float opacity, float tickTime) {
        Vector4f color = this.getColor(tickTime);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)(opacity * color.w));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void render(float opacity, float tickTime, RenderGuiOverlayEvent.Pre event) {
        double width = event.getWindow().m_85441_();
        double height = event.getWindow().m_85442_();
        double scale = event.getWindow().m_85449_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.setupRender(opacity, tickTime);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, height / scale, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_(width / scale, height / scale, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_(width / scale, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void vignette(RenderGuiOverlayEvent.Pre event) {
        if (!this.test((Entity)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        LivingEntity entity = this.entity();
        float effect = (float)this.getEffectFactor();
        float tickTime = (float)entity.f_19797_ + event.getPartialTick();
        if (event.getOverlay() == VanillaGuiOverlay.VIGNETTE.type()) {
            float opacity = CSMath.blend(0.0f, 1.0f, effect, 0.0f, 1.0f);
            if (opacity == 0.0f) {
                return;
            }
            this.render(opacity, tickTime, event);
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

