/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FreezeHealingEffect
extends TempEffect {
    public FreezeHealingEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent event) {
        if (!this.test((Entity)event.getEntity())) {
            return;
        }
        double effect = this.getEffectFactor();
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        if (heartsFreezePercentage == 0.0) {
            return;
        }
        float maxHealth = this.entity().m_21233_();
        float maxFrozenHealth = (float)((double)maxHealth * heartsFreezePercentage);
        float frozenHealth = Math.round(CSMath.blend(0.0, (double)maxFrozenHealth, effect, 0.0, 1.0));
        float unfrozenHealth = maxHealth - frozenHealth;
        float healAmount = CSMath.clamp(event.getAmount(), 0.0f, Math.max(0.0f, unfrozenHealth - this.entity().m_21223_()));
        event.setAmount(healAmount);
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.SERVER;
    }
}

