/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.common.block.IceboxBlock;
import com.momosoftworks.coldsweat.common.blockentity.IceboxBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class IceboxBlockEntityRenderer
implements BlockEntityRenderer<IceboxBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cold_sweat", "textures/block/icebox.png");
    public static final ResourceLocation TEXTURE_SMOKESTACK = new ResourceLocation("cold_sweat", "textures/block/icebox_smokestack.png");
    public static final ResourceLocation TEXTURE_FROST = new ResourceLocation("cold_sweat", "textures/block/icebox_frost.png");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("cold_sweat", "icebox"), "main");
    ModelPart container;
    ModelPart lid;

    public IceboxBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart base = context.m_173582_(LAYER_LOCATION);
        this.container = base.m_171324_("container");
        this.lid = base.m_171324_("lid");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition lid = partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -3.0f, -16.0f, 16.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)8.0f));
        PartDefinition container = partdefinition.m_171599_("container", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-8.0f, -13.0f, -8.0f, 16.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void render(IceboxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockstate = blockEntity.m_58900_();
        poseStack.m_85836_();
        float rotation = ((Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotation));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        VertexConsumer vertexes = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)IceboxBlockEntityRenderer.getTexture(blockstate)));
        if (!((Boolean)blockstate.m_61143_((Property)IceboxBlock.SMOKESTACK)).booleanValue()) {
            float openness = blockEntity.m_6683_(partialTick);
            openness = 1.0f - openness;
            openness = 1.0f - (float)Math.pow(openness, 3.0);
            this.lid.f_104203_ = -(openness * 1.5707964f) * 0.999f;
        } else {
            this.lid.f_104203_ = 0.0f;
        }
        this.container.m_104301_(poseStack, vertexes, light, overlay);
        this.lid.m_104301_(poseStack, vertexes, light, overlay);
        if (((Boolean)blockstate.m_61143_((Property)IceboxBlock.FROSTED)).booleanValue()) {
            VertexConsumer frostedVertexes = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_FROST));
            this.container.m_104301_(poseStack, frostedVertexes, light, overlay);
        }
        poseStack.m_85849_();
    }

    public static ResourceLocation getTexture(BlockState state) {
        return (Boolean)state.m_61143_((Property)IceboxBlock.SMOKESTACK) != false ? TEXTURE_SMOKESTACK : TEXTURE;
    }
}

