/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ItemInsulationManager {
    public static SidedCapabilityCache<IInsulatableCap, ItemStack> CAP_CACHE = new SidedCapabilityCache(ModCapabilities.ITEM_INSULATION);

    public static LazyOptional<IInsulatableCap> getInsulationCap(ItemStack stack) {
        return ItemInsulationManager.isInsulatable(stack) ? CAP_CACHE.get(stack) : LazyOptional.empty();
    }

    public static int getInsulationSlots(ItemStack stack) {
        if (ItemInsulationManager.isInsulatable(stack)) {
            Item item = stack.m_41720_();
            Optional slotOverride = ConfigSettings.INSULATION_SLOT_OVERRIDES.get().get((Object)item).stream().findFirst();
            if (slotOverride.isPresent() && ((ItemInsulationSlotsData)slotOverride.get()).test(stack)) {
                return ((ItemInsulationSlotsData)slotOverride.get()).slots();
            }
            return ConfigSettings.INSULATION_SLOTS.get().getSlots(LivingEntity.m_147233_((ItemStack)stack), stack);
        }
        return 0;
    }

    public static boolean isInsulatable(ItemStack stack) {
        Equipable equipable;
        Item item = stack.m_41720_();
        return item instanceof Equipable && (equipable = (Equipable)item).m_40402_().m_254934_() && !ConfigSettings.INSULATION_BLACKLIST.get().contains(stack.m_41720_()) && ItemInsulationManager.getInsulatorInsulation(stack).isEmpty();
    }

    public static int getSlotsFilled(Collection<InsulatorData> insulators) {
        int slots = 0;
        for (InsulatorData data : insulators) {
            if (data.fillSlots()) {
                slots += Insulation.splitList(data.insulation()).size();
                continue;
            }
            ++slots;
        }
        return slots;
    }

    public static Multimap<Item, InsulatorData> getInsulatorsForSlotType(Insulation.Slot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case Insulation.Slot.ITEM -> ConfigSettings.INSULATION_ITEMS.get();
            case Insulation.Slot.ARMOR -> ConfigSettings.INSULATING_ARMORS.get();
            case Insulation.Slot.CURIO -> ConfigSettings.INSULATING_CURIOS.get();
        };
    }

    public static List<Insulation> getInsulatorInsulation(ItemStack stack) {
        if (!ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.m_41720_())) {
            return ImmutableList.of();
        }
        return ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.m_41720_()).stream().map(InsulatorData::insulation).flatMap(Collection::stream).filter(ins -> !ins.isEmpty()).toList();
    }

    public static List<InsulatorData> getInsulatorsForStack(ItemStack stack, Insulation.Slot slot) {
        if (stack.m_41619_()) {
            return new ArrayList<InsulatorData>();
        }
        ArrayList<InsulatorData> insulators = new ArrayList<InsulatorData>();
        if (slot == Insulation.Slot.ARMOR && ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> insulators.addAll(ItemInsulationManager.getAppliedArmorInsulators(stack)));
        }
        insulators.addAll(ItemInsulationManager.getInsulatorsForSlotType(slot).get((Object)stack.m_41720_()));
        return insulators;
    }

    public static List<InsulatorData> getAppliedArmorInsulators(ItemStack armor) {
        return ((List)ItemInsulationManager.getInsulationCap(armor).map(IInsulatableCap::getInsulation).orElse(new ArrayList())).stream().map(Pair::getSecond).flatMap(Collection::stream).toList();
    }

    public static List<AttributeModifier> getArmorInsulationAttributes(ItemStack stack, Attribute attribute, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        for (InsulatorData insulator : ItemInsulationManager.getInsulatorsForStack(stack, Insulation.Slot.ARMOR)) {
            if (!insulator.test(owner, stack)) continue;
            modifiers.addAll(insulator.attributes().get(attribute).stream().filter(mod -> operation == null || mod.m_22217_() == operation).toList());
        }
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Attribute attribute, EquipmentSlot slot, @Nullable AttributeModifier.Operation operation, @Nullable Entity owner) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(operation != null ? stack.m_41638_(slot).get((Object)attribute).stream().filter(mod -> mod.m_22217_() == operation).toList() : stack.m_41638_(slot).get((Object)attribute));
        modifiers.addAll(ItemInsulationManager.getArmorInsulationAttributes(stack, attribute, operation, owner));
        return modifiers;
    }

    public static List<AttributeModifier> getAttributeModifiersForSlot(ItemStack stack, Attribute attribute, EquipmentSlot slot) {
        return ItemInsulationManager.getAttributeModifiersForSlot(stack, attribute, slot, null, null);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        static ContainerListener INSULATION_LISTENER = new ContainerListener(){

            public void m_7934_(AbstractContainerMenu sendingContainer, int slot, ItemStack stack) {
                ItemStack containerStack = sendingContainer.m_38853_(slot).m_7993_();
                ItemInsulationManager.getInsulationCap(containerStack).ifPresent(cap -> {
                    containerStack.m_41784_().m_128473_("Insulation");
                    containerStack.m_41784_().m_128391_((CompoundTag)cap.serializeNBT());
                });
            }

            public void m_142153_(AbstractContainerMenu sendingContainer, int slot, int value) {
            }
        };

        @SubscribeEvent
        public static void attachCapabilityToItemHandler(AttachCapabilitiesEvent<ItemStack> event) {
            ItemStack stack = (ItemStack)event.getObject();
            if (ItemInsulationManager.isInsulatable(stack)) {
                final ItemInsulationCap itemInsulationCap = new ItemInsulationCap();
                final LazyOptional capOptional = LazyOptional.of(() -> itemInsulationCap);
                final Capability<IInsulatableCap> capability = ModCapabilities.ITEM_INSULATION;
                ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
                        if (cap == capability) {
                            return capOptional.cast();
                        }
                        return LazyOptional.empty();
                    }

                    public CompoundTag serializeNBT() {
                        return itemInsulationCap.serializeNBT();
                    }

                    public void deserializeNBT(CompoundTag nbt) {
                        itemInsulationCap.deserializeNBT(nbt);
                    }
                };
                event.addCapability(new ResourceLocation("cold_sweat", "item_insulation"), (ICapabilityProvider)provider);
            }
        }

        @SubscribeEvent
        public static void handleInventoryOpen(PlayerContainerEvent event) {
            event.getEntity().getPersistentData().m_128379_("InventoryOpen", event instanceof PlayerContainerEvent.Open);
        }

        @SubscribeEvent
        public static void clearCachePeriodically(TickEvent.LevelTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.level.m_46467_() % 200L == 0L) {
                CAP_CACHE.clear();
            }
        }

        @SubscribeEvent
        public static void onContainerOpen(PlayerContainerEvent.Open event) {
            event.getContainer().m_38893_(INSULATION_LISTENER);
        }

        @SubscribeEvent
        public static void onContainerClose(PlayerContainerEvent.Close event) {
            event.getContainer().m_38943_(INSULATION_LISTENER);
        }
    }
}

