/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.insulation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;

public class ItemInsulationCap
implements IInsulatableCap {
    private final List<Pair<ItemStack, List<InsulatorData>>> insulation = new ArrayList<Pair<ItemStack, List<InsulatorData>>>();
    private boolean changed = false;
    private CompoundTag serializedData = null;
    public static final Codec<Pair<ItemStack, List<InsulatorData>>> ITEM_INSULATION_PAIR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(Pair::getFirst), (App)InsulatorData.CODEC.listOf().fieldOf("insulation").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    public static final Codec<ItemInsulationCap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITEM_INSULATION_PAIR_CODEC.listOf().fieldOf("insulation").forGetter(ItemInsulationCap::getInsulation)).apply((Applicative)instance, ItemInsulationCap::new));

    public ItemInsulationCap() {
    }

    public ItemInsulationCap(List<Pair<ItemStack, List<InsulatorData>>> insulation) {
        this.insulation.addAll(insulation);
    }

    @Override
    public List<Pair<ItemStack, List<InsulatorData>>> getInsulation() {
        return this.insulation;
    }

    @Override
    public List<InsulatorData> getInsulators() {
        return this.insulation.stream().map(Pair::getSecond).flatMap(Collection::stream).toList();
    }

    public void calcAdaptiveInsulation(double worldTemp, double minTemp, double maxTemp) {
        for (Pair<ItemStack, List<InsulatorData>> entry : this.insulation) {
            for (InsulatorData insulatorData : (List)entry.getSecond()) {
                List<Insulation> entryDataList = insulatorData.insulation();
                for (int i = 0; i < entryDataList.size(); ++i) {
                    Insulation entryInsul = entryDataList.get(i);
                    if (!(entryInsul instanceof AdaptiveInsulation)) continue;
                    AdaptiveInsulation insul = (AdaptiveInsulation)entryInsul;
                    double newFactor = AdaptiveInsulation.calculateChange(insul, worldTemp, minTemp, maxTemp);
                    insul.setFactor(newFactor);
                }
            }
        }
        this.changed = true;
    }

    @Override
    public void addInsulationItem(ItemStack stack) {
        List<InsulatorData> insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)stack.m_41720_()).stream().map(InsulatorData::copy).toList();
        if (!insulation.isEmpty()) {
            this.insulation.add((Pair<ItemStack, List<InsulatorData>>)Pair.of((Object)stack, insulation));
            this.changed = true;
        }
    }

    @Override
    public ItemStack removeInsulationItem(ItemStack stack) {
        Optional<Pair> toRemove = this.insulation.stream().filter(entry -> ((ItemStack)entry.getFirst()).equals(stack)).findFirst();
        toRemove.ifPresent(pair -> {
            this.insulation.remove(pair);
            this.changed = true;
        });
        return stack;
    }

    @Override
    public ItemStack getInsulationItem(int index) {
        return (ItemStack)this.insulation.get(index).getFirst();
    }

    @Override
    public boolean canAddInsulationItem(ItemStack armorItem, ItemStack insulationItem) {
        List<InsulatorData> insulation = ConfigSettings.INSULATION_ITEMS.get().get((Object)insulationItem.m_41720_()).stream().filter(insulator -> insulator.test(null, insulationItem)).toList();
        if (insulation.isEmpty()) {
            return false;
        }
        int appliedInsulators = 0;
        for (InsulatorData data : ConfigSettings.INSULATING_ARMORS.get().get((Object)armorItem.m_41720_())) {
            if (!data.fillSlots()) continue;
            appliedInsulators += Insulation.splitList(data.insulation()).size();
        }
        appliedInsulators += ItemInsulationManager.getSlotsFilled(CSMath.append(insulation, this.getInsulators()));
        return (appliedInsulators = Math.max(1, appliedInsulators)) <= ItemInsulationManager.getInsulationSlots(armorItem);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt;
        if (!this.changed && this.serializedData != null) {
            return this.serializedData;
        }
        DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this);
        this.serializedData = nbt = result.result().orElse(new CompoundTag());
        this.changed = false;
        return nbt;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (Objects.equals(tag, this.serializedData)) {
            return;
        }
        CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().ifPresent(result -> {
            List<Pair<ItemStack, List<InsulatorData>>> newInsulation = ((ItemInsulationCap)result.getFirst()).getInsulation();
            if (!newInsulation.equals(this.insulation)) {
                this.insulation.clear();
                this.insulation.addAll(newInsulation);
                this.changed = true;
            }
        });
    }

    @Override
    public void copy(IInsulatableCap cap) {
        this.insulation.clear();
        this.insulation.addAll(cap.getInsulation());
    }
}

