/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public enum Preference {
    UNITS("Units", FriendlyByteBuf::m_130068_, buf -> (Temperature.Units)buf.m_130066_(Temperature.Units.class), () -> ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F),
    WATERSKIN_PRIMARY("WaterskinPrimary", FriendlyByteBuf::m_130068_, buf -> (WaterskinAction)buf.m_130066_(WaterskinAction.class), ConfigSettings.WATERSKIN_USE_PRIMARY),
    WATERSKIN_SECONDARY("WaterskinSecondary", FriendlyByteBuf::m_130068_, buf -> (WaterskinAction)buf.m_130066_(WaterskinAction.class), ConfigSettings.WATERSKIN_USE_SECONDARY);

    private final String key;
    private final FriendlyByteBuf.Writer<?> writer;
    private final FriendlyByteBuf.Reader<?> reader;
    private final Supplier<?> getter;

    private <T> Preference(String key, FriendlyByteBuf.Writer<T> writer, FriendlyByteBuf.Reader<T> reader, Supplier<T> getter) {
        this.key = key;
        this.writer = writer;
        this.reader = reader;
        this.getter = getter;
    }

    public String key() {
        return this.key;
    }

    public FriendlyByteBuf.Writer writer() {
        return this.writer;
    }

    public FriendlyByteBuf.Reader reader() {
        return this.reader;
    }

    public Supplier getter() {
        return this.getter;
    }

    @Nullable
    public static <T> T get(Player player, Preference preference) {
        CompoundTag preferenceNBT = player.getPersistentData().m_128469_("ColdSweatPreferences");
        if (!preferenceNBT.m_128441_(preference.key())) {
            return null;
        }
        return (T)NBTHelper.deserialize(preferenceNBT.m_128423_(preference.key()));
    }

    public static <T> T getOrDefault(Player player, Preference preference, T defaultValue) {
        return (T)CSMath.orElse(Preference.get(player, preference), defaultValue);
    }

    public static enum WaterskinAction implements StringRepresentable
    {
        DRINK("drink"),
        POUR("pour"),
        NONE("none");

        private final String name;

        private WaterskinAction(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static WaterskinAction byName(String name) {
            return (WaterskinAction)EnumHelper.byName((Enum[])WaterskinAction.values(), (String)name);
        }
    }
}

