/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class MixinCampfire {
    @Inject(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at={@At(value="HEAD")})
    private static void onItemCook(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo ci) {
        double maxStrength = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() * 0.6;
        double tempRate = ConfigSettings.TEMP_RATE.get();
        for (int i = 0; i < blockEntity.m_59065_().size(); ++i) {
            ItemStack stack = (ItemStack)blockEntity.m_59065_().get(i);
            if (!stack.m_150930_(ModItems.FILLED_WATERSKIN) || (level.m_46467_() & 4L) != 0L) continue;
            CompoundTag tag = stack.m_41784_();
            double temperature = tag.m_128459_("Temperature");
            if (!state.m_204336_(BlockTags.f_13087_) || !CSMath.betweenExclusive(tag.m_128459_("Temperature"), -maxStrength, maxStrength)) continue;
            double delta = tempRate * 0.1;
            if (state.m_204336_(ModBlockTags.SOUL_FIRE) && ConfigSettings.COLD_SOUL_FIRE.get().booleanValue()) {
                delta *= -1.0;
            }
            tag.m_128347_("Temperature", temperature + delta);
        }
    }

    @ModifyArg(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Containers;dropItemStack(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"), index=4)
    private static ItemStack onItemFinishedCooking(Level level, double x, double y, double z, ItemStack result) {
        if (result.m_150930_(ModItems.FILLED_WATERSKIN)) {
            double maxStrength = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() * 0.6;
            CompoundTag tag = result.m_41784_();
            BlockState state = level.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z));
            if (state.m_204336_(BlockTags.f_13087_)) {
                double newTemp = maxStrength;
                if (state.m_204336_(ModBlockTags.SOUL_FIRE) && ConfigSettings.COLD_SOUL_FIRE.get().booleanValue()) {
                    newTemp *= -1.0;
                }
                tag.m_128347_("Temperature", newTemp);
            }
        }
        return result;
    }
}

