/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks.entity;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.blocks.PilloryBlock;
import com.lazrproductions.cuffed.compat.PlayerReviveCompat;
import com.lazrproductions.cuffed.init.ModBlockEntities;
import com.lazrproductions.cuffed.init.ModDamageTypes;
import com.lazrproductions.cuffed.init.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GuillotineBlockEntity
extends BlockEntity {
    static final String TAG_IS_DOWN = "IsDown";
    static final String TAG_IS_BLOODY = "IsBloody";
    public boolean isBloody;
    public boolean isDown;
    int chopDelay = 0;

    public GuillotineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GUILLOTINE.get(), pos, state);
    }

    public void interact(@Nonnull Level l, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (!l.m_5776_()) {
            this.isDown = !this.isDown;
            l.m_5594_(null, pos, this.isDown ? ModSounds.GUILLOTINE_USE : ModSounds.PILLORY_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (this.isDown) {
                this.chopDelay = 5;
            }
            GuillotineBlockEntity.m_155232_((Level)l, (BlockPos)pos, (BlockState)state);
            l.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void chop(@Nonnull Level l, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Player player = PilloryBlock.getDetainedEntity(l, state, pos);
        if (player != null) {
            if (CuffedMod.PlayerReviveInstalled) {
                PlayerReviveCompat.Kill(player);
            } else {
                player.m_6074_();
            }
            player.m_6469_(ModDamageTypes.GetModSource((Entity)player, ModDamageTypes.HANG, null), Float.MAX_VALUE);
            if (((Boolean)CuffedMod.SERVER_CONFIG.GUILLOTINE_DROPS_HEAD.get()).booleanValue()) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42680_, 1);
                stack.m_41784_().m_128359_("SkullOwner", player.m_36316_().getName());
                ItemEntity entity = new ItemEntity(l, player.m_20182_().m_7096_(), player.m_20182_().m_7098_(), player.m_20182_().m_7094_(), stack);
                l.m_7967_((Entity)entity);
            }
            this.isBloody = true;
        }
    }

    public void tick(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (this.chopDelay > 0) {
            --this.chopDelay;
            if (this.chopDelay == 0) {
                this.chop(level, pos, state);
            }
        }
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_(TAG_IS_DOWN, this.isDown);
        tag.m_128379_(TAG_IS_BLOODY, this.isBloody);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.isDown = tag.m_128471_(TAG_IS_DOWN);
        this.isBloody = tag.m_128471_(TAG_IS_BLOODY);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }
}

