/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.entity;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.entity.base.IAnchorableEntity;
import com.lazrproductions.cuffed.init.ModEnchantments;
import com.lazrproductions.cuffed.init.ModEntityTypes;
import com.lazrproductions.cuffed.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class WeightedAnchorEntity
extends LivingEntity {
    private static final EntityDataAccessor<Boolean> DATA_ENCHANTED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    ListTag enchantments = new ListTag();

    public WeightedAnchorEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    public WeightedAnchorEntity(Level world, BlockPos pos) {
        super((EntityType)ModEntityTypes.WEIGHTED_ANCHOR.get(), world);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static WeightedAnchorEntity createFromItem(@Nonnull Level level, @Nonnull ItemStack stack, @Nonnull BlockPos pos) {
        WeightedAnchorEntity entity = new WeightedAnchorEntity(level, pos);
        entity.setEnchantments(stack.m_41785_());
        return entity;
    }

    public ItemStack getDroppedItem() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.WEIGHTED_ANCHOR_ITEM.get(), 1);
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44882_((ListTag)this.getEnchantments()), (ItemStack)stack);
        return stack;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ENCHANTED, (Object)false);
        super.m_8097_();
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(DATA_ENCHANTED, (Object)(this.getEnchantments().size() > 0 ? 1 : 0));
            if (this.m_20072_() && this.getEnchantmentLevel((Enchantment)ModEnchantments.BUOYANT.get()) >= 1) {
                this.m_246865_(new Vec3(0.0, (double)0.023f, 0.0));
            }
        }
        super.m_8119_();
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        return !source.m_276093_(DamageTypes.f_286979_);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11745_, SoundEvents.f_11666_);
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getDroppedItem();
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, 0.5, 0.0);
    }

    public Vec3 m_7398_(float p_20347_) {
        return this.m_20182_().m_82549_(this.m_7939_());
    }

    public boolean m_6097_() {
        return false;
    }

    public InteractionResult m_6096_(@Nonnull Player interactor, @Nonnull InteractionHand hand) {
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            if (!interactor.m_6047_() && ((Boolean)CuffedMod.SERVER_CONFIG.ANCHORING_ALLOW_ANCHORING_TO_WEIGHTED_ANCHORS.get()).booleanValue()) {
                boolean flag = false;
                double maxDist = ((Float)CuffedMod.SERVER_CONFIG.ANCHORING_SUFFOCATION_LENGTH.get()).floatValue() + 5.0f;
                List list = this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20185_() - maxDist - 2.0, this.m_20186_() - maxDist - 2.0, this.m_20189_() - maxDist - 2.0, this.m_20185_() + maxDist + 2.0, this.m_20186_() + maxDist + 2.0, this.m_20189_() + maxDist + 2.0));
                for (LivingEntity entity : list) {
                    IAnchorableEntity anchorableEntity = (IAnchorableEntity)entity;
                    if (anchorableEntity.getAnchor() != interactor) continue;
                    anchorableEntity.setAnchoredTo((Entity)this);
                    flag = true;
                }
                boolean flag1 = false;
                if (!flag) {
                    for (LivingEntity entity : list) {
                        IAnchorableEntity anchorableEntity = (IAnchorableEntity)entity;
                        if (!anchorableEntity.isAnchored() || anchorableEntity.getAnchor() != this) continue;
                        anchorableEntity.setAnchoredTo(null);
                        flag1 = true;
                    }
                    if (flag1) {
                        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 0.7f, 1.0f);
                    }
                }
                if (flag) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11745_, SoundSource.PLAYERS, 0.7f, 1.0f);
                }
                if (flag1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 0.7f, 1.0f);
                }
                if (flag || flag1) {
                    this.m_146852_(GameEvent.f_157791_, (Entity)interactor);
                }
                return InteractionResult.CONSUME;
            }
            ItemStack stack = this.getDroppedItem();
            ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), stack);
            this.m_9236_().m_7967_((Entity)entity);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11664_, SoundSource.PLAYERS, 0.7f, 1.0f);
            this.m_146870_();
        }
        return InteractionResult.FAIL;
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        tag.m_128365_("Enchantments", (Tag)this.enchantments);
        super.m_7380_(tag);
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        this.enchantments = tag.m_128441_("Enchantments") ? tag.m_128437_("Enchantments", 10) : new ListTag();
        super.m_7378_(tag);
    }

    public ListTag getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(ListTag tag) {
        this.enchantments = tag;
    }

    public boolean hasEnchantment(Enchantment enchantment) {
        ResourceLocation resourcelocation = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        for (int i = 0; i < this.enchantments.size(); ++i) {
            CompoundTag compoundtag = this.enchantments.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return true;
        }
        return false;
    }

    public int getEnchantmentLevel(Enchantment enchantment) {
        ResourceLocation resourcelocation = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        for (int i = 0; i < this.enchantments.size(); ++i) {
            CompoundTag compoundtag = this.enchantments.m_128728_(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
        }
        return 0;
    }

    public void enchant(Enchantment enchantment, int value) {
        ResourceLocation l = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        this.enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)l, (int)value));
    }

    public boolean getIsEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ENCHANTED);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>(0);
    }

    public ItemStack m_6844_(@Nonnull EquipmentSlot p_21127_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@Nonnull EquipmentSlot p_21036_, @Nonnull ItemStack p_21037_) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }
}

