/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.inventory.tooltip;

import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.items.TrayItem;
import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrayTooltip
implements ClientTooltipComponent,
TooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cuffed", (String)"textures/gui/container/tray.png");
    public static final ScreenTexture BACKGROUND_TEXTURE = new ScreenTexture(ResourceLocation.fromNamespaceAndPath((String)"cuffed", (String)"textures/gui/container/tray.png"), 0.0f, 0.0f, 39, 20, 128, 128);
    public static final ScreenTexture FORK_TEXTURE = new ScreenTexture(ResourceLocation.fromNamespaceAndPath((String)"cuffed", (String)"textures/gui/container/tray.png"), 0.0f, 20.0f, 5, 15, 128, 128);
    public static final ScreenTexture SPOON_TEXTURE = new ScreenTexture(ResourceLocation.fromNamespaceAndPath((String)"cuffed", (String)"textures/gui/container/tray.png"), 5.0f, 20.0f, 5, 15, 128, 128);
    public static final ScreenTexture KNIFE_TEXTURE = new ScreenTexture(ResourceLocation.fromNamespaceAndPath((String)"cuffed", (String)"textures/gui/container/tray.png"), 10.0f, 20.0f, 5, 15, 128, 128);
    private final NonNullList<ItemStack> items;

    public TrayTooltip(NonNullList<ItemStack> Items2) {
        this.items = Items2;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_142103_() {
        return 20;
    }

    public int m_142069_(@Nonnull Font font) {
        return 39;
    }

    public void m_183452_(@Nonnull Font font, int x, int y, @Nonnull GuiGraphics gui) {
        int i;
        ScreenUtilities.drawTexture((GuiGraphics)gui, (BlitCoordinates)new BlitCoordinates(x, y, 39, 20), (ScreenTexture)BACKGROUND_TEXTURE);
        int foodSlot = this.getTrayFoodSlot();
        if (foodSlot > -1) {
            this.renderSlot(x + 1, y + 1, foodSlot, gui, font);
        }
        int spoons = this.hasSpoon();
        int forks = this.hasFork();
        int knifes = this.hasKnife();
        int nextX = 0;
        for (i = 0; i < forks; ++i) {
            ScreenUtilities.drawTexture((GuiGraphics)gui, (BlitCoordinates)new BlitCoordinates(x + 18 + nextX, y + 2, 5, 15), (ScreenTexture)FORK_TEXTURE);
            nextX += 6;
        }
        for (i = 0; i < spoons; ++i) {
            ScreenUtilities.drawTexture((GuiGraphics)gui, (BlitCoordinates)new BlitCoordinates(x + 18 + nextX, y + 2, 5, 15), (ScreenTexture)SPOON_TEXTURE);
            nextX += 6;
        }
        for (i = 0; i < knifes; ++i) {
            ScreenUtilities.drawTexture((GuiGraphics)gui, (BlitCoordinates)new BlitCoordinates(x + 18 + nextX, y + 2, 5, 15), (ScreenTexture)KNIFE_TEXTURE);
            nextX += 6;
        }
    }

    private void renderSlot(int x, int y, int index, GuiGraphics gui, Font p_281863_) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        gui.m_280256_(itemstack, x + 1, y + 1, index);
        gui.m_280370_(p_281863_, itemstack, x + 1, y + 1);
    }

    private int getTrayFoodSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!TrayItem.itemIsFood((ItemStack)this.items.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int hasSpoon() {
        int c = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_150930_((Item)ModItems.SPOON.get())) continue;
            ++c;
        }
        return c;
    }

    private int hasFork() {
        int c = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_150930_((Item)ModItems.FORK.get())) continue;
            ++c;
        }
        return c;
    }

    private int hasKnife() {
        int c = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_150930_((Item)ModItems.KNIFE.get())) continue;
            ++c;
        }
        return c;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        SLOT(0, 0, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int p_169928_, int p_169929_, int p_169930_, int p_169931_) {
            this.x = p_169928_;
            this.y = p_169929_;
            this.w = p_169930_;
            this.h = p_169931_;
        }
    }
}

