/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.mixin;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.entity.base.IDetainableEntity;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin {
    @Inject(method={"onPress"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPress(long windowId, int keyCode, int scanCode, int f3, CallbackInfo callback) {
        Minecraft inst = Minecraft.m_91087_();
        LocalPlayer player = inst.f_91074_;
        if (player != null && inst.f_91080_ == null) {
            IDetainableEntity detainable;
            if (inst.f_91080_ != null) {
                return;
            }
            RestrainableCapability cap = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
            if (cap != null && cap.isRestrained()) {
                cap.onMouseInput((Player)player, keyCode, scanCode);
                for (int i : cap.gatherBlockedInputs()) {
                    if (keyCode != i) continue;
                    callback.cancel();
                    return;
                }
            }
            if (player instanceof IDetainableEntity && (detainable = (IDetainableEntity)player).getDetained() > -1) {
                for (int i : MouseHandlerMixin.getBlockedKeyCodesWhenDetained()) {
                    if (keyCode != i) continue;
                    callback.cancel();
                    return;
                }
            }
        }
    }

    @Inject(method={"onScroll"}, at={@At(value="HEAD")}, cancellable=true)
    private void onScroll(long windowId, double deltaX, double deltaY, CallbackInfo callback) {
        Minecraft inst = Minecraft.m_91087_();
        LocalPlayer player = inst.f_91074_;
        if (player != null) {
            IDetainableEntity detainable;
            if (inst.f_91080_ != null) {
                return;
            }
            RestrainableCapability cap = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)player);
            if (cap != null && cap.armsRestrained()) {
                callback.cancel();
                return;
            }
            if (player instanceof IDetainableEntity && (detainable = (IDetainableEntity)player).getDetained() > -1) {
                callback.cancel();
                return;
            }
        }
    }

    private static ArrayList<Integer> getBlockedKeyCodesWhenDetained() {
        ArrayList<Integer> b = new ArrayList<Integer>();
        Minecraft inst = Minecraft.m_91087_();
        if (inst == null || inst.f_91066_ == null) {
            return b;
        }
        b.add(inst.f_91066_.f_92096_.getKey().m_84873_());
        b.add(inst.f_91066_.f_92095_.getKey().m_84873_());
        b.add(inst.f_91066_.f_92092_.getKey().m_84873_());
        b.add(inst.f_91066_.f_92094_.getKey().m_84873_());
        for (KeyMapping i : inst.f_91066_.f_92056_) {
            b.add(i.getKey().m_84873_());
        }
        b.add(inst.f_91066_.f_92092_.getKey().m_84873_());
        b.add(inst.f_91066_.f_92097_.getKey().m_84873_());
        b.add(inst.f_91066_.f_92093_.getKey().m_84873_());
        block25: for (KeyMapping mapping : inst.f_91066_.f_92059_) {
            switch (mapping.m_90860_()) {
                case "key.parcool.Crawl": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.Breakfall": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.WallSlide": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.Vault": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.Flipping": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.FastRun": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.ClingToCliff": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.HangDown": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.WallJump": {
                    b.add(mapping.getKey().m_84873_());
                    continue block25;
                }
                case "key.parcool.HorizontalWallRun": {
                    b.add(mapping.getKey().m_84873_());
                }
            }
        }
        return b;
    }
}

