/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.mixin;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.blocks.PilloryBlock;
import com.lazrproductions.cuffed.blocks.base.DetentionBlock;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.effect.RestrainedEffectInstance;
import com.lazrproductions.cuffed.entity.base.IDetainableEntity;
import com.lazrproductions.cuffed.entity.base.INicknamable;
import com.lazrproductions.cuffed.entity.base.IPrivacyOperand;
import com.lazrproductions.cuffed.entity.base.IRestrainableEntity;
import com.lazrproductions.cuffed.init.ModEffects;
import com.lazrproductions.cuffed.restraints.base.IEnchantableRestraint;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin
extends LivingEntity
implements IRestrainableEntity,
IDetainableEntity,
INicknamable,
IPrivacyOperand {
    private static final EntityDataAccessor<Boolean> DATA_HAS_NICKNAME = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Component> DATA_NICKNAME = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private static final String NICKNAME_TAG = "Nickname";
    private static final EntityDataAccessor<Integer> DATA_RESTRAINT_CODE = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_ARM_RESTRAINT_ID = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_LEG_RESTRAINT_ID = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_HEAD_RESTRAINT_ID = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DATA_ARM_ENCHANTED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_LEG_ENCHANTED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HEAD_ENCHANTED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_DETAINED = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> DATA_DETAINED_TO_BLOCK = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Float> DATA_DETAINED_ROTATION = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Vector3f> DATA_DETAINED_POSITION = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final String DETAINED_TAG = "Detained";
    private static final String DETAINED_ID_TAG = "Id";
    private static final String DETAINED_ROTATION_TAG = "Rotation";
    private static final String DETAINED_TO_BLOCK_TAG = "Block";
    private static final String DETAINED_POSITION_X_TAG = "X";
    private static final String DETAINED_POSITION_Y_TAG = "Y";
    private static final String DETAINED_POSITION_Z_TAG = "Z";
    float pilloryBreakOutProgress = 0.0f;
    boolean wasCrouching;
    boolean hasProcessedSwing = false;
    final HashMap<String, IPrivacyOperand.PrivacyRestriction> privacyRestrictions = new HashMap();

    protected PlayerMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    protected void defineSynchedData(CallbackInfo callback) {
        this.f_19804_.m_135372_(DATA_HAS_NICKNAME, (Object)false);
        this.f_19804_.m_135372_(DATA_NICKNAME, (Object)Component.m_237119_());
        this.f_19804_.m_135372_(DATA_RESTRAINT_CODE, (Object)0);
        this.f_19804_.m_135372_(DATA_ARM_RESTRAINT_ID, (Object)"");
        this.f_19804_.m_135372_(DATA_LEG_RESTRAINT_ID, (Object)"");
        this.f_19804_.m_135372_(DATA_HEAD_RESTRAINT_ID, (Object)"");
        this.f_19804_.m_135372_(DATA_ARM_ENCHANTED, (Object)false);
        this.f_19804_.m_135372_(DATA_LEG_ENCHANTED, (Object)false);
        this.f_19804_.m_135372_(DATA_HEAD_ENCHANTED, (Object)false);
        this.f_19804_.m_135372_(DATA_DETAINED, (Object)-1);
        this.f_19804_.m_135372_(DATA_DETAINED_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_DETAINED_TO_BLOCK, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DATA_DETAINED_POSITION, (Object)new Vector3f());
    }

    @Inject(at={@At(value="HEAD")}, method={"getName"}, cancellable=true)
    public void getName(CallbackInfoReturnable<Component> callback) {
        Component n;
        if (((Boolean)this.f_19804_.m_135370_(DATA_HAS_NICKNAME)).booleanValue() && (n = this.getNickname()) != null) {
            callback.setReturnValue((Object)n);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getDisplayName"}, cancellable=true)
    public void getDisplayName(CallbackInfoReturnable<Component> callback) {
        Component n;
        if (((Boolean)this.f_19804_.m_135370_(DATA_HAS_NICKNAME)).booleanValue() && (n = this.getNickname()) != null) {
            callback.setReturnValue((Object)n);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo callback) {
        if (!this.m_9236_().m_5776_()) {
            Object object;
            RestrainableCapability cap = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)this);
            if (cap != null) {
                IEnchantableRestraint e;
                this.setArmRestraintId(cap.getArmRestraintId());
                this.setLegRestraintId(cap.getLegRestraintId());
                this.setHeadRestraintId(cap.getHeadRestraintId());
                object = cap.getArmRestraint();
                this.setArmsEnchanted(object instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)object).getEnchantments() != null && e.getEnchantments().size() > 0);
                object = cap.getLegRestraint();
                this.setLegsEnchanted(object instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)object).getEnchantments() != null && e.getEnchantments().size() > 0);
                object = cap.getHeadRestraint();
                this.setHeadEnchanted(object instanceof IEnchantableRestraint && (e = (IEnchantableRestraint)object).getEnchantments() != null && e.getEnchantments().size() > 0);
            }
            if (!this.m_21023_((MobEffect)ModEffects.RESTRAINED_EFFECT.get())) {
                this.setRestraintCode(0);
            } else {
                object = this.m_21124_((MobEffect)ModEffects.RESTRAINED_EFFECT.get());
                if (object instanceof RestrainedEffectInstance) {
                    RestrainedEffectInstance i = (RestrainedEffectInstance)((Object)object);
                    this.setRestraintCode(i.m_19564_());
                }
            }
            if (this.getDetained() > -1) {
                this.m_5618_(this.getDetainedRotation());
                this.m_146922_(this.getDetainedRotation());
                this.m_6021_(this.getDetainedPosition().x(), this.getDetainedPosition().y(), this.getDetainedPosition().z());
                if (this.m_6084_()) {
                    if (!this.wasCrouching && this.m_6047_()) {
                        this.pilloryBreakOutProgress += 1.0f;
                        this.wasCrouching = true;
                    } else if (this.wasCrouching && !this.m_6047_()) {
                        this.pilloryBreakOutProgress += 1.0f;
                        this.wasCrouching = false;
                    }
                    BlockPos pos = (BlockPos)this.f_19804_.m_135370_(DATA_DETAINED_TO_BLOCK);
                    BlockState state = this.getBlockDetainedTo(this.m_9236_());
                    boolean flag = state.m_60734_() instanceof DetentionBlock;
                    boolean flag1 = false;
                    if (((Boolean)CuffedMod.SERVER_CONFIG.ALLOW_BREAKING_OUT_OF_PILLORY.get()).booleanValue()) {
                        if (this.pilloryBreakOutProgress >= 100.0f) {
                            if (state.m_60734_() instanceof PilloryBlock) {
                                this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                                this.m_9236_().m_247517_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS);
                                this.undetain();
                                this.pilloryBreakOutProgress = 0.0f;
                            }
                        } else {
                            Block block = state.m_60734_();
                            if (block instanceof DetentionBlock) {
                                DetentionBlock detentionBlock = (DetentionBlock)block;
                                flag1 = detentionBlock.canDetainPlayer(this.m_9236_(), state, (BlockPos)this.f_19804_.m_135370_(DATA_DETAINED_TO_BLOCK), (Player)this, false);
                            }
                            if (!flag || !flag1) {
                                this.undetain();
                            }
                        }
                    }
                } else {
                    this.undetain();
                }
            }
            if (((Boolean)CuffedMod.SERVER_CONFIG.ALLOW_SELF_RESTRAINING.get()).booleanValue()) {
                if (this.f_20911_) {
                    if (!this.hasProcessedSwing) {
                        this.hasProcessedSwing = true;
                        ServerPlayer me = (ServerPlayer)this;
                        this.attemptToRemoveRestraint(me, cap);
                    }
                } else {
                    this.hasProcessedSwing = false;
                }
            }
        }
    }

    public boolean attemptToRemoveRestraint(ServerPlayer player, RestrainableCapability cap) {
        boolean armsRestrained = cap.armsRestrained();
        if (!armsRestrained) {
            Vec3 lookAngle = player.m_20154_();
            if (lookAngle.f_82480_ >= 0.005817764438688755) {
                cap.onInteractedByOther(player, player, 2.0, this.m_21120_(InteractionHand.MAIN_HAND), InteractionHand.MAIN_HAND, true);
                return true;
            }
            if (lookAngle.f_82480_ <= -0.3333333432674408) {
                cap.onInteractedByOther(player, player, 0.0, this.m_21120_(InteractionHand.MAIN_HAND), InteractionHand.MAIN_HAND, true);
                return true;
            }
            cap.onInteractedByOther(player, player, 1.0, this.m_21120_(InteractionHand.MAIN_HAND), InteractionHand.MAIN_HAND, true);
            return true;
        }
        return false;
    }

    @Inject(at={@At(value="HEAD")}, method={"wantsToStopRiding"}, cancellable=true)
    protected void wantsToStopRiding(CallbackInfoReturnable<Boolean> callback) {
        IRestrainableCapability cap = CuffedAPI.Capabilities.getRestrainableCapability((Player)this);
        if (cap.restraintsDisabledMovement()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    public void onAddAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        CompoundTag detainedTag = new CompoundTag();
        detainedTag.m_128405_(DETAINED_ID_TAG, this.getDetained());
        detainedTag.m_128350_(DETAINED_ROTATION_TAG, this.getDetainedRotation());
        BlockPos blockPos = (BlockPos)this.f_19804_.m_135370_(DATA_DETAINED_TO_BLOCK);
        detainedTag.m_128385_(DETAINED_TO_BLOCK_TAG, new int[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()});
        Vector3f pos = (Vector3f)this.f_19804_.m_135370_(DATA_DETAINED_POSITION);
        detainedTag.m_128350_(DETAINED_POSITION_X_TAG, pos.x());
        detainedTag.m_128350_(DETAINED_POSITION_Y_TAG, pos.y());
        detainedTag.m_128350_(DETAINED_POSITION_Z_TAG, pos.z());
        tag.m_128365_(DETAINED_TAG, (Tag)detainedTag);
        if (((Boolean)CuffedMod.SERVER_CONFIG.NICKNAME_PERSISTS_ON_LOGOUT.get()).booleanValue() && this.getNickname() != null) {
            tag.m_128359_(NICKNAME_TAG, this.serializeNickname());
        }
        tag.m_128365_("PrivacyRestrictions", (Tag)this.serializeRestrictions());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    public void onReadAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        if (tag.m_128441_(DETAINED_TAG)) {
            CompoundTag t = tag.m_128469_(DETAINED_TAG);
            this.setDetained(t.m_128451_(DETAINED_ID_TAG));
            this.setDetainedRotation(t.m_128457_(DETAINED_ROTATION_TAG));
            int[] a = t.m_128465_(DETAINED_TO_BLOCK_TAG);
            this.setBlockDetainedTo(new BlockPos(a[0], a[1], a[2]));
            this.setDetainedPosition(new Vector3f(t.m_128457_(DETAINED_POSITION_X_TAG), t.m_128457_(DETAINED_POSITION_Y_TAG), t.m_128457_(DETAINED_POSITION_Z_TAG)));
        }
        if (((Boolean)CuffedMod.SERVER_CONFIG.NICKNAME_PERSISTS_ON_LOGOUT.get()).booleanValue() && tag.m_128441_(NICKNAME_TAG)) {
            this.setNickname((Component)Component.Serializer.m_130701_((String)tag.m_128461_(NICKNAME_TAG)));
        } else {
            this.setNickname(null);
        }
        this.deserializeRestrictions(tag);
    }

    @Override
    public Component getNickname() {
        if (((Boolean)this.f_19804_.m_135370_(DATA_HAS_NICKNAME)).booleanValue()) {
            return (Component)this.f_19804_.m_135370_(DATA_NICKNAME);
        }
        return null;
    }

    @Override
    public void setNickname(@Nullable Component value) {
        if (value == null) {
            this.f_19804_.m_135381_(DATA_HAS_NICKNAME, (Object)false);
            this.f_19804_.m_135381_(DATA_NICKNAME, (Object)Component.m_237119_());
        } else {
            this.f_19804_.m_135381_(DATA_HAS_NICKNAME, (Object)true);
            this.f_19804_.m_135381_(DATA_NICKNAME, (Object)value);
        }
    }

    @Override
    public String serializeNickname() {
        return Component.Serializer.m_130703_((Component)this.getNickname());
    }

    @Override
    public void deserializeNickname(CompoundTag tag) {
        if (tag.m_128441_(NICKNAME_TAG)) {
            this.setNickname((Component)Component.Serializer.m_130701_((String)tag.m_128461_(NICKNAME_TAG)));
        }
    }

    @Override
    public void deserializeNickname(String nickTag) {
        this.setNickname((Component)Component.Serializer.m_130701_((String)nickTag));
    }

    @Override
    public boolean isRestrained() {
        return (Integer)this.f_19804_.m_135370_(DATA_RESTRAINT_CODE) > 0;
    }

    @Override
    public int getRestraintCode() {
        return (Integer)this.f_19804_.m_135370_(DATA_RESTRAINT_CODE);
    }

    @Override
    public ResourceLocation getArmRestraintId() {
        return ResourceLocation.bySeparator((String)((String)this.f_19804_.m_135370_(DATA_ARM_RESTRAINT_ID)), (char)':');
    }

    @Override
    public ResourceLocation getLegRestraintId() {
        return ResourceLocation.bySeparator((String)((String)this.f_19804_.m_135370_(DATA_LEG_RESTRAINT_ID)), (char)':');
    }

    @Override
    public ResourceLocation getHeadRestraintId() {
        return ResourceLocation.bySeparator((String)((String)this.f_19804_.m_135370_(DATA_HEAD_RESTRAINT_ID)), (char)':');
    }

    @Override
    public void setRestraintCode(int v) {
        this.f_19804_.m_135381_(DATA_RESTRAINT_CODE, (Object)v);
    }

    @Override
    public void setArmRestraintId(ResourceLocation v) {
        this.f_19804_.m_135381_(DATA_ARM_RESTRAINT_ID, (Object)v.toString());
    }

    @Override
    public void setLegRestraintId(ResourceLocation v) {
        this.f_19804_.m_135381_(DATA_LEG_RESTRAINT_ID, (Object)v.toString());
    }

    @Override
    public void setHeadRestraintId(ResourceLocation v) {
        this.f_19804_.m_135381_(DATA_HEAD_RESTRAINT_ID, (Object)v.toString());
    }

    @Override
    public boolean getArmsAreEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ARM_ENCHANTED);
    }

    @Override
    public boolean getLegsAreEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LEG_ENCHANTED);
    }

    @Override
    public boolean getHeadIsEnchanted() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HEAD_ENCHANTED);
    }

    @Override
    public void setArmsEnchanted(boolean v) {
        this.f_19804_.m_135381_(DATA_ARM_ENCHANTED, (Object)v);
    }

    @Override
    public void setLegsEnchanted(boolean v) {
        this.f_19804_.m_135381_(DATA_LEG_ENCHANTED, (Object)v);
    }

    @Override
    public void setHeadEnchanted(boolean v) {
        this.f_19804_.m_135381_(DATA_HEAD_ENCHANTED, (Object)v);
    }

    @Override
    public void detainToBlock(@Nonnull Level level, Vector3f detainPos, @Nonnull BlockPos pos, int detaintType, float facingRotation) {
        this.setDetained(detaintType);
        this.setDetainedRotation(facingRotation);
        this.setBlockDetainedTo(pos);
        this.setDetainedPosition(detainPos);
    }

    @Override
    public void undetain() {
        this.setDetained(-1);
        this.setDetainedRotation(0.0f);
        this.setBlockDetainedTo(BlockPos.f_121853_);
        this.setDetainedPosition(new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @Override
    public int getDetained() {
        return (Integer)this.f_19804_.m_135370_(DATA_DETAINED);
    }

    @Override
    public void setDetained(int value) {
        this.f_19804_.m_135381_(DATA_DETAINED, (Object)value);
    }

    @Override
    public float getDetainedRotation() {
        return ((Float)this.f_19804_.m_135370_(DATA_DETAINED_ROTATION)).floatValue();
    }

    @Override
    public void setDetainedRotation(float value) {
        this.f_19804_.m_135381_(DATA_DETAINED_ROTATION, (Object)Float.valueOf(value));
    }

    @Override
    public BlockState getBlockDetainedTo(@Nonnull Level level) {
        return level.m_8055_((BlockPos)this.f_19804_.m_135370_(DATA_DETAINED_TO_BLOCK));
    }

    @Override
    public void setBlockDetainedTo(@Nonnull BlockPos pos) {
        this.f_19804_.m_135381_(DATA_DETAINED_TO_BLOCK, (Object)pos);
    }

    @Override
    public Vector3f getDetainedPosition() {
        return (Vector3f)this.f_19804_.m_135370_(DATA_DETAINED_POSITION);
    }

    @Override
    public void setDetainedPosition(Vector3f value) {
        this.f_19804_.m_135381_(DATA_DETAINED_POSITION, (Object)value);
    }

    @Override
    public IPrivacyOperand.PrivacyRestriction getAnchoringRestrictions() {
        return this.getRestriction("cuffed:anchoring");
    }

    @Override
    public void setAnchoringRestrictions(IPrivacyOperand.PrivacyRestriction newRestriction) {
        this.setRestriction("cuffed:anchoring", newRestriction);
    }

    @Override
    public IPrivacyOperand.PrivacyRestriction getDetainingRestrictions() {
        return this.getRestriction("cuffed:detaining");
    }

    @Override
    public void setDetainingRestrictions(IPrivacyOperand.PrivacyRestriction newRestriction) {
        this.setRestriction("cuffed:detaining", newRestriction);
    }

    @Override
    public IPrivacyOperand.PrivacyRestriction getNicknamingRestrictions() {
        return this.getRestriction("cuffed:nicknaming");
    }

    @Override
    public void setNicknamingRestrictions(IPrivacyOperand.PrivacyRestriction newRestriction) {
        this.setRestriction("cuffed:nicknaming", newRestriction);
    }

    @Override
    public IPrivacyOperand.PrivacyRestriction getRestrainingRestrictions() {
        return this.getRestriction("cuffed:restraining");
    }

    @Override
    public void setRestrainingRestrictions(IPrivacyOperand.PrivacyRestriction newRestriction) {
        this.setRestriction("cuffed:restraining", newRestriction);
    }

    @Override
    public void setRestriction(String key, IPrivacyOperand.PrivacyRestriction newRestriction) {
        this.privacyRestrictions.put(key, newRestriction);
    }

    @Override
    public IPrivacyOperand.PrivacyRestriction getRestriction(String key) {
        return this.privacyRestrictions.get(key);
    }

    @Override
    public void deserializeRestrictions(CompoundTag tag) {
        if (tag.m_128441_("PrivacyRestrictions")) {
            this.privacyRestrictions.clear();
            if (tag.m_128440_() == 0) {
                ListTag list = tag.m_128437_("PrivacyRestrictions", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag t = list.m_128728_(i);
                    this.privacyRestrictions.put(t.m_128461_(DETAINED_ID_TAG), IPrivacyOperand.PrivacyRestriction.fromInteger(t.m_128451_("RestrictionLevel")));
                }
                return;
            }
        }
        this.writeDefaultRestrictions();
    }

    @Override
    public ListTag serializeRestrictions() {
        ListTag list = new ListTag();
        if (this.privacyRestrictions.size() == 0) {
            this.writeDefaultRestrictions();
        }
        for (Map.Entry<String, IPrivacyOperand.PrivacyRestriction> r : this.privacyRestrictions.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("RestrictionLevel", r.getValue().toInteger());
            tag.m_128359_(DETAINED_ID_TAG, r.getKey());
            list.add((Object)tag);
        }
        return list;
    }

    @Override
    public void writeDefaultRestrictions() {
        this.privacyRestrictions.clear();
        this.privacyRestrictions.put("cuffed:anchoring", IPrivacyOperand.PrivacyRestriction.NEVER);
        this.privacyRestrictions.put("cuffed:detaining", IPrivacyOperand.PrivacyRestriction.NEVER);
        this.privacyRestrictions.put("cuffed:nicknaming", IPrivacyOperand.PrivacyRestriction.NEVER);
        this.privacyRestrictions.put("cuffed:restraining", IPrivacyOperand.PrivacyRestriction.NEVER);
    }

    @Shadow
    public Iterable<ItemStack> m_6168_() {
        return null;
    }

    @Shadow
    public ItemStack m_6844_(@Nonnull EquipmentSlot p_21127_) {
        return null;
    }

    @Shadow
    public void m_8061_(@Nonnull EquipmentSlot p_21036_, @Nonnull ItemStack p_21037_) {
    }

    @Shadow
    public HumanoidArm m_5737_() {
        return null;
    }
}

