/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.packet;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.lazrslib.common.network.packet.ParameterizedLazrPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class LockpickLockPacket
extends ParameterizedLazrPacket {
    int speedIncreasePerPick;
    int progressPerPick;
    int stopCode;
    int lockId;
    String lockpickerUUID;

    public LockpickLockPacket(int lockId, int speedIncreasePerTick, int progressPerPick, String lockpickerUUID) {
        super(new Object[]{speedIncreasePerTick, progressPerPick, -1, lockId, lockpickerUUID});
        this.stopCode = -1;
        this.lockId = lockId;
        this.speedIncreasePerPick = speedIncreasePerTick;
        this.progressPerPick = progressPerPick;
        this.lockpickerUUID = lockpickerUUID;
    }

    public LockpickLockPacket(boolean wasFailed, int lockId, String lockpickerUUID) {
        super(new Object[]{0, 0, wasFailed ? 0 : 2, lockId, lockpickerUUID});
        this.stopCode = wasFailed ? 0 : 2;
        this.lockId = lockId;
        this.lockpickerUUID = lockpickerUUID;
    }

    public LockpickLockPacket(FriendlyByteBuf buf) {
        super(buf);
    }

    public void loadValues(Object[] arg0) {
        this.speedIncreasePerPick = (Integer)arg0[0];
        this.progressPerPick = (Integer)arg0[1];
        this.stopCode = (Integer)arg0[2];
        this.lockId = (Integer)arg0[3];
        this.lockpickerUUID = (String)arg0[4];
    }

    public void handleClientside(Supplier<NetworkEvent.Context> ctx) {
        Clientside.handleClientside(ctx, this.speedIncreasePerPick, this.progressPerPick, this.stopCode, this.lockId, this.lockpickerUUID);
    }

    public void handleServerside(Supplier<NetworkEvent.Context> ctx) {
        Serverside.handleServerside(ctx, this.speedIncreasePerPick, this.progressPerPick, this.stopCode, this.lockId, this.lockpickerUUID);
    }

    static class Clientside {
        Clientside() {
        }

        public static void handleClientside(Supplier<NetworkEvent.Context> ctx, int speedIncreasePerPick, int progressPerPick, int stopCode, int lockId, String lockpickerUUID) {
            if (stopCode <= -1) {
                Minecraft instance = Minecraft.m_91087_();
                CuffedAPI.Lockpicking.beginLockpickingLock(instance, lockId, speedIncreasePerPick, progressPerPick);
            }
        }
    }

    static class Serverside {
        Serverside() {
        }

        public static void handleServerside(Supplier<NetworkEvent.Context> ctx, int speedIncreasePerPick, int progressPerPick, int stopCode, int lockId, String lockpickerUUID) {
            if (stopCode > -1) {
                CuffedAPI.Lockpicking.finishLockpickingLock(stopCode == 0, lockId, UUID.fromString(lockpickerUUID));
            }
        }
    }
}

