/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.recipes;

import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModRecipes;
import com.lazrproductions.cuffed.items.KeyItem;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class KeyRingDisassembleRecipe
extends CustomRecipe {
    public KeyRingDisassembleRecipe(ResourceLocation idIn, CraftingBookCategory category) {
        super(idIn, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        CompoundTag tag;
        ItemStack ringStack = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            if (inv.m_8020_(i).m_150930_((Item)ModItems.KEY_RING.get())) {
                ringStack = inv.m_8020_(i);
                continue;
            }
            return false;
        }
        return ringStack != null && (tag = ringStack.m_41784_()) != null && tag.m_128451_("Keys") > 0;
    }

    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess access) {
        ItemStack ringStack = null;
        if (this.matches(inv, null)) {
            ListTag boundKeysTag;
            CompoundTag tag;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                if (inv.m_8020_(i).m_41619_() || !inv.m_8020_(i).m_150930_((Item)ModItems.KEY_RING.get())) continue;
                ringStack = inv.m_8020_(i);
            }
            if (ringStack != null && (tag = ringStack.m_41784_()).m_128441_("BoundLocks") && (boundKeysTag = tag.m_128437_("BoundLocks", 10)).size() > 0) {
                ItemStack stack = ((Item)ModItems.KEY.get()).m_7968_();
                stack.m_41764_(1);
                CompoundTag keyOnRingTag = boundKeysTag.m_128728_(boundKeysTag.size() - 1);
                KeyItem.setBoundId(stack, keyOnRingTag.m_128342_("Id"));
                if (keyOnRingTag.m_128441_("Name")) {
                    CompoundTag t = new CompoundTag();
                    t.m_128359_("Name", keyOnRingTag.m_128461_("Name"));
                    stack.m_41784_().m_128365_("display", (Tag)t);
                }
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.KEY_RING_DISASSEMBLE.get();
    }

    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ListTag boundKeysTag;
            ItemStack stack = container.m_8020_(i);
            CompoundTag tag = stack.m_41784_();
            if (!stack.m_150930_((Item)ModItems.KEY_RING.get()) || !tag.m_128441_("Keys") || tag.m_128451_("Keys") <= 1) continue;
            int numOfKeys = tag.m_128451_("Keys");
            if (tag.m_128441_("BoundLocks") && (boundKeysTag = tag.m_128437_("BoundLocks", 10)).size() > 0) {
                boundKeysTag.remove(boundKeysTag.size() - 1);
                tag.m_128365_("BoundLocks", (Tag)boundKeysTag);
                tag.m_128405_("Keys", numOfKeys - 1);
            }
            nonnulllist.set(i, (Object)stack.m_41777_());
        }
        return nonnulllist;
    }
}

