/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.client.model.animations.GoblinAnimations;
import com.idark.valoria.registries.entity.living.AbstractGoblin;
import com.idark.valoria.registries.entity.living.Goblin;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class GoblinModel<T extends Goblin>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart right_arm;
    private final ModelPart left_arm;

    public GoblinModel(ModelPart pRoot) {
        this.root = pRoot;
        this.head = pRoot.m_171324_("head");
        this.body = pRoot.m_171324_("body");
        this.left_leg = pRoot.m_171324_("left_leg");
        this.right_leg = pRoot.m_171324_("right_leg");
        this.left_arm = pRoot.m_171324_("left_arm");
        this.right_arm = pRoot.m_171324_("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -4.0575f, -2.5695f, 9.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(34, 0).m_171488_(-4.5f, -4.0575f, -2.5695f, 9.0f, 7.0f, 6.0f, new CubeDeformation(0.45f)).m_171514_(0, 37).m_171488_(-1.0f, 0.7302f, -3.1695f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0576f, (float)-0.4213f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(24, 1).m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)6.4582f, (float)-0.0576f, (float)0.9043f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(24, 1).m_171480_().m_171488_(-2.5f, -2.0f, 0.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)-6.4582f, (float)-0.0576f, (float)0.9043f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-3.4999f, -4.0501f, -2.0f, 7.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.0153f, (float)14.0501f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(22, 13).m_171488_(-1.5f, -4.632f, -1.5035f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)14.6308f, (float)-0.0918f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-1.5f, -4.5224f, -1.4999f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)14.5211f, (float)0.0663f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(12, 25).m_171480_().m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(12, 34).m_171480_().m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.45f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)21.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(24, 25).m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 34).m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.45f)), PartPose.m_171419_((float)-2.0f, (float)21.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createOldBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -2.9f, -2.6528f, 9.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.9f, (float)-0.3472f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.2746f, (float)-0.15f, (float)-0.0868f));
        PartDefinition left_ear_cube_r1 = left_ear.m_171599_("left_ear_cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171488_(-4.9f, -18.0f, -2.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 3).m_171488_(-6.9f, -20.0f, -2.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.2746f, (float)18.25f, (float)0.434f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.2746f, (float)-0.15f, (float)-0.0868f));
        PartDefinition right_ear_cube_r1 = right_ear.m_171599_("right_ear_cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(3.9f, -18.0f, -2.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 0).m_171480_().m_171488_(3.9f, -20.0f, -2.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-5.2746f, (float)18.25f, (float)0.434f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-3.5f, -4.0f, -2.0f, 7.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(22, 13).m_171488_(-1.5f, -4.5f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)14.5f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-1.5f, -4.5f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)14.5f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(12, 25).m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)21.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(24, 25).m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)21.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.m_171324_((String)"right_ear").f_104204_ = Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.06f;
        this.head.m_171324_((String)"left_ear").f_104204_ = Mth.m_14031_((float)(ageInTicks * -0.06f)) * 0.06f;
        this.head.m_171324_((String)"right_ear").f_104203_ = Mth.m_14031_((float)(ageInTicks * 0.01f)) * 0.01f;
        this.head.m_171324_((String)"left_ear").f_104203_ = Mth.m_14031_((float)(ageInTicks * -0.01f)) * 0.01f;
        if (entity.m_5912_()) {
            if (!entity.m_21205_().m_41619_()) {
                this.m_233385_(((Goblin)((Object)entity)).attackAnimationState, GoblinAnimations.ATTACK_WEAPON, ageInTicks, 2.0f);
            } else {
                this.m_233385_(((Goblin)((Object)entity)).attackAnimationState, GoblinAnimations.ATTACK, ageInTicks, 1.0f);
            }
            AnimationUtils.m_102082_((ModelPart)this.right_arm, (ModelPart)this.left_arm, (float)ageInTicks);
        }
        if (((AbstractGoblin)((Object)entity)).isLowHP() || entity.m_20142_()) {
            this.m_267799_(GoblinAnimations.RUN, limbSwing, limbSwingAmount, 4.0f, 2.0f);
        } else {
            this.m_267799_(GoblinAnimations.WALK, limbSwing, limbSwingAmount, 2.0f, 2.0f);
        }
        this.m_233385_(((Goblin)((Object)entity)).idleAnimationState, GoblinAnimations.IDLE, ageInTicks, 0.5f);
    }

    protected ModelPart getArm(HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        ModelPart arm = this.getArm(pSide);
        arm.m_104299_(pPoseStack);
        float handOffset = pSide == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        pPoseStack.m_252880_(handOffset / 16.0f, 0.0f, 0.0f);
        pPoseStack.m_252880_(0.015f, -0.32f, 0.065f);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

