/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.registries.entity.living.minions.PixieEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PixieModel
extends HierarchicalModel<PixieEntity> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart bodyGlow;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public PixieModel(ModelPart pRoot) {
        super(RenderType::m_110473_);
        this.root = pRoot;
        this.body = this.root.m_171324_("body");
        this.bodyGlow = this.body.m_171324_("body_glow");
        this.leftWing = this.root.m_171324_("left_wing");
        this.rightWing = this.root.m_171324_("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -8.0f, -1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)24.0f, (float)-3.0f));
        PartDefinition body_glow = body.m_171599_("body_glow", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-3.0f, (float)-4.0f, (float)3.0f));
        PartDefinition left_wing = partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-7.0f, -8.0f, -1.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)24.0f, (float)1.0f));
        PartDefinition right_wing = partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171480_().m_171488_(4.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(PixieEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float beat;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.bodyGlow.f_233553_ = beat = 0.9f + Mth.m_14154_((float)Mth.m_14031_((float)(pAgeInTicks * 0.1f))) * 0.15f;
        this.bodyGlow.f_233554_ = beat;
        this.bodyGlow.f_233555_ = beat;
        this.leftWing.f_104205_ = Mth.m_14089_((float)(pAgeInTicks * 5.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 180) * 6.0f;
        this.rightWing.f_104205_ = -this.leftWing.f_104205_;
        this.leftWing.f_104204_ = 0.25f + Mth.m_14089_((float)(pAgeInTicks * 45.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 180) * 16.2f;
        this.rightWing.f_104204_ = -this.leftWing.f_104204_;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

