/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.client.model.animations.GoblinAnimations;
import com.idark.valoria.client.model.animations.SorcererAnimations;
import com.idark.valoria.client.model.entity.AbstractHierarchicalModel;
import com.idark.valoria.registries.entity.living.SorcererEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class SorcererModel<T extends SorcererEntity>
extends AbstractHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public SorcererModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, 2.375f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(-3.0f, 0.375f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 52).m_171488_(-2.0f, -2.625f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 8).m_171488_(-1.0f, -4.625f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.625f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(38, 51).m_171488_(-0.8667f, -4.9667f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(46, 54).m_171488_(-0.8667f, -4.9667f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.4f)).m_171514_(48, 44).m_171488_(-1.7667f, -5.5667f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.2333f, (float)4.0667f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(-4.0f, -9.875f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 28).m_171488_(-4.0f, -9.875f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)).m_171514_(40, 0).m_171488_(-4.0f, 2.125f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.4f)).m_171514_(24, 44).m_171488_(-4.0f, 2.125f, -2.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.875f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(56, 8).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 59).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(56, 20).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(56, 32).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 52).m_171488_(-1.1333f, -4.9667f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(54, 54).m_171488_(-1.1333f, -4.9667f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.4f)).m_171514_(24, 51).m_171488_(-1.2333f, -5.5667f, -2.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.2333f, (float)4.0667f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    protected ModelPart getArm(HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.m_267799_(GoblinAnimations.WALK, pLimbSwing, pLimbSwingAmount, 3.0f, 6.0f);
        this.animateIdle(((SorcererEntity)((Object)pEntity)).idleAnimationState, SorcererAnimations.IDLE, pLimbSwingAmount, pAgeInTicks, 1.0f);
        this.m_233385_(((SorcererEntity)((Object)pEntity)).healAnimationState, SorcererAnimations.HEAL, pAgeInTicks, 1.0f);
        this.m_233385_(((SorcererEntity)((Object)pEntity)).attackHatAnimationState, SorcererAnimations.ATTACK_MAGIC_HAT, pAgeInTicks, 1.0f);
        this.m_233385_(((SorcererEntity)((Object)pEntity)).attackAnimationState, SorcererAnimations.ATTACK_MAGIC, pAgeInTicks, 1.0f);
    }
}

