/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.model.entity;

import com.idark.valoria.client.model.animations.GoblinAnimations;
import com.idark.valoria.client.model.animations.TrollAnimations;
import com.idark.valoria.client.model.entity.AbstractHierarchicalModel;
import com.idark.valoria.registries.entity.living.Troll;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TrollModel<T extends Troll>
extends AbstractHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public TrollModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.leftEar = this.head.m_171324_("left_ear");
        this.rightEar = this.head.m_171324_("right_ear");
        this.body = root.m_171324_("body");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-4.0f, -1.4f, -3.8f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-5.0f, 4.6f, -3.8f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-4.0f, -1.4f, -3.8f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-6.6f, (float)-0.2f));
        PartDefinition right_horn_r1 = head.m_171599_("right_horn_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171488_(0.0f, -3.0f, -2.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-4.4f, (float)-0.3f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition left_horn_r1 = head.m_171599_("left_horn_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(0.0f, -3.0f, -2.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-4.4f, (float)-0.3f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, 5.5f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)-5.5f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.5f, 5.5f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.5f, (float)-5.5f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 22).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 6).m_171488_(-4.0f, -6.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(48, 38).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 38).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)6.0f, (float)6.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(48, 38).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 38).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 38).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 38).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 38).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.m_6973_(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.head.m_171324_((String)"right_ear").f_104204_ = Mth.m_14031_((float)(pAgeInTicks * 0.25f)) * 0.06f;
        this.head.m_171324_((String)"left_ear").f_104204_ = Mth.m_14031_((float)(pAgeInTicks * -0.25f)) * 0.06f;
        this.head.m_171324_((String)"right_ear").f_104203_ = Mth.m_14031_((float)(pAgeInTicks * 0.15f)) * 0.01f;
        this.head.m_171324_((String)"left_ear").f_104203_ = Mth.m_14031_((float)(pAgeInTicks * -0.15f)) * 0.01f;
        if (this.f_102609_) {
            this.head.f_104202_ = 2.0f;
            this.head.f_104201_ = -3.0f;
            this.body.f_104202_ = 4.0f;
            this.body.f_104201_ = 10.0f;
            this.leftArm.f_104201_ = 8.0f;
            this.rightArm.f_104201_ = 8.0f;
            this.leftArm.f_104202_ = 1.0f;
            this.rightArm.f_104202_ = 1.0f;
            this.rightArm.f_104203_ += -0.62831855f;
            this.leftArm.f_104203_ += -0.62831855f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.2617994f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.2617994f;
            this.leftLeg.f_104205_ = -0.07853982f;
        }
        this.m_267799_(GoblinAnimations.WALK, pLimbSwing, pLimbSwingAmount, 2.0f, 6.0f);
        this.animateIdle(((Troll)((Object)pEntity)).idleAnimationState, TrollAnimations.IDLE, pLimbSwingAmount, pAgeInTicks, 0.5f);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

