/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.entity;

import com.idark.valoria.client.model.entity.CrystalModel;
import com.idark.valoria.registries.entity.living.minions.CrystalEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import pro.komaru.tridot.client.ClientTick;

public class CrystalRenderer
extends MobRenderer<CrystalEntity, CrystalModel<CrystalEntity>> {
    protected static final ResourceLocation TEXTURE_ICE = new ResourceLocation("valoria", "textures/entity/crystal_ice.png");
    protected static final ResourceLocation TEXTURE_FIRE = new ResourceLocation("valoria", "textures/entity/crystal_fire.png");
    protected static final ResourceLocation TEXTURE_POISON = new ResourceLocation("valoria", "textures/entity/crystal_poison.png");

    public CrystalRenderer(EntityRendererProvider.Context context) {
        super(context, new CrystalModel(CrystalModel.createBodyLayer().m_171564_()), 0.0f);
    }

    public void render(CrystalEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        double ticksUp = ((float)ClientTick.ticksInGame + pPartialTicks) * 8.0f;
        pMatrixStack.m_85836_();
        pMatrixStack.m_252880_(0.0f, (float)(Math.sin(Math.toRadians(ticksUp %= 360.0)) * 0.03125), 0.0f);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(CrystalEntity pEntity) {
        return switch (pEntity.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case CrystalEntity.Variant.POISON -> TEXTURE_POISON;
            case CrystalEntity.Variant.ICE -> TEXTURE_ICE;
            case CrystalEntity.Variant.FIRE -> TEXTURE_FIRE;
        };
    }
}

