/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.tile;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.block.entity.CrushableBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrushableBlockRenderer
implements BlockEntityRenderer<CrushableBlockEntity> {
    public void render(CrushableBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        if (pBlockEntity.m_58904_() != null) {
            int i = (Integer)pBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_271112_);
            boolean isIce = pBlockEntity.m_58900_().m_60713_((Block)BlockRegistry.suspiciousIce.get());
            if (i > 0 || isIce) {
                Direction direction = pBlockEntity.getHitDirection();
                ItemStack itemstack = pBlockEntity.getItem();
                if (direction != null) {
                    if (!itemstack.m_41619_()) {
                        pPoseStack.m_85836_();
                        pPoseStack.m_252880_(0.0f, 0.5f, 0.0f);
                        float[] afloat = this.translations(direction, i);
                        pPoseStack.m_252880_(afloat[0], afloat[1], afloat[2]);
                        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(75.0f));
                        boolean flag = direction == Direction.EAST || direction == Direction.WEST;
                        pPoseStack.m_252781_(Axis.f_252436_.m_252977_((float)((flag ? 90 : 0) + 11)));
                        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
                        int j = LevelRenderer.m_109537_((BlockAndTintGetter)pBlockEntity.m_58904_(), (BlockState)pBlockEntity.m_58900_(), (BlockPos)pBlockEntity.m_58899_().m_121945_(direction));
                        Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.FIXED, j, OverlayTexture.f_118083_, pPoseStack, pBuffer, pBlockEntity.m_58904_(), 0);
                        pPoseStack.m_85849_();
                    }
                } else {
                    RandomSource random = pBlockEntity.m_58904_().f_46441_;
                    random.m_188584_(pBlockEntity.m_58899_().m_121878_());
                    if (!itemstack.m_41619_()) {
                        pPoseStack.m_85836_();
                        double xOffset = random.m_188500_() * 0.22 - 0.1;
                        double yOffset = random.m_188500_() * 0.22 - 0.1;
                        double zOffset = random.m_188500_() * 0.22 - 0.1;
                        pPoseStack.m_85837_(0.5 + xOffset, 0.6 + yOffset, 0.5 + zOffset);
                        double yawDegrees = (random.m_188500_() * 0.7 + 0.1) * 180.0;
                        if (yawDegrees < 0.0) {
                            yawDegrees += 360.0;
                        }
                        pPoseStack.m_252781_(Axis.f_252436_.m_252977_((float)yawDegrees));
                        double pitchDegrees = (random.m_188500_() * 0.7 + 0.1) * 180.0 - 90.0;
                        if (pitchDegrees < 0.0) {
                            pitchDegrees += 360.0;
                        }
                        pPoseStack.m_252781_(Axis.f_252529_.m_252977_((float)pitchDegrees));
                        pPoseStack.m_85841_(0.8f, 0.8f, 0.8f);
                        Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, (Level)Minecraft.m_91087_().f_91073_, 0);
                        pPoseStack.m_85849_();
                    }
                }
            }
        }
    }

    private float[] translations(Direction pDirection, int pDustedLevel) {
        float[] afloat = new float[]{0.5f, 0.0f, 0.5f};
        float f = (float)pDustedLevel / 10.0f * 0.85f;
        switch (pDirection) {
            case EAST: {
                afloat[0] = 0.73f + f;
                break;
            }
            case WEST: {
                afloat[0] = 0.25f - f;
                break;
            }
            case UP: {
                afloat[1] = 0.25f + f;
                break;
            }
            case DOWN: {
                afloat[1] = -0.23f - f;
                break;
            }
            case NORTH: {
                afloat[2] = 0.25f - f;
                break;
            }
            case SOUTH: {
                afloat[2] = 0.73f + f;
            }
        }
        return afloat;
    }
}

