/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.render.bossbars.ClientBossbar;
import pro.komaru.tridot.api.render.bossbars.TridotBossBar;
import pro.komaru.tridot.client.BossBarsOverlay;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.common.config.ClientConfig;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

@OnlyIn(value=Dist.CLIENT)
public class BasicBossbar
extends ClientBossbar {
    public int fadeTime = 0;
    public float shakeSpeed = 1.5f;
    public float shakeThreshold = 0.25f;
    public float maxOffset = 1.0f;
    public Col color = Col.white.copy();

    public BasicBossbar(UUID uuid, Component component) {
        super(uuid, component);
    }

    public TridotBossBar setHealth(float health, float maxHealth) {
        return super.setHealth(health, maxHealth);
    }

    public void render(BossBarsOverlay overlay, GuiGraphics pGuiGraphics, int baseOffset, Minecraft mc) {
        int screenWidth = pGuiGraphics.m_280182_();
        PoseStack poseStack = pGuiGraphics.m_280168_();
        poseStack.m_85836_();
        this.calculateShake(poseStack);
        if (this.isAboutToDie() && this.fadeTime <= 100) {
            ++this.fadeTime;
        }
        RenderSystem.enableBlend();
        float alpha = Mth.m_14179_((float)Interp.pow2Out.apply((float)this.fadeTime / 100.0f), (float)1.0f, (float)0.0f);
        int argb = this.color.a(alpha + 0.1f).toARGB();
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        if (((Boolean)ClientConfig.BOSSBAR_TITLE.get()).booleanValue()) {
            this.increase(32);
            MutableComponent name = this.getName().m_6881_().m_130946_(": " + (int)this.getHealth() + "/" + (int)this.getMaxHealth());
            this.renderBossbar(baseOffset, screenWidth, pGuiGraphics, mc);
            int nameX = screenWidth / 2 - mc.f_91062_.m_92852_((FormattedText)name) / 2;
            int nameY = baseOffset + 30;
            pGuiGraphics.m_280430_(mc.f_91062_, (Component)name, nameX, nameY, argb);
        } else {
            this.increase(26);
            this.renderBossbar(baseOffset, screenWidth, pGuiGraphics, mc);
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private void calculateShake(PoseStack poseStack) {
        float shakeIntensity = 0.0f;
        if (this.percentage <= this.shakeThreshold) {
            shakeIntensity = 1.0f - this.percentage / this.shakeThreshold;
            shakeIntensity = Math.max(0.0f, Math.min(1.0f, shakeIntensity));
        }
        if (shakeIntensity > 0.0f) {
            float offsetX = (float)Math.sin((double)((float)ClientTick.ticksInGame * this.shakeSpeed) * 0.5) * this.maxOffset * shakeIntensity;
            float offsetY = (float)Math.sin((double)((float)ClientTick.ticksInGame * this.shakeSpeed) * 0.7) * this.maxOffset * shakeIntensity;
            poseStack.m_252880_(offsetX, offsetY, 0.0f);
        }
    }

    public float getPercentage() {
        float time = Util.m_137550_() - this.setTime;
        float delta = Mth.m_14036_((float)(time / 200.0f), (float)0.0f, (float)1.0f);
        return Mth.m_14179_((float)Interp.sine.apply(delta), (float)this.percentage, (float)this.targetPercent);
    }

    public void renderBossbar(int baseOffset, int screenWidth, GuiGraphics pGuiGraphics, Minecraft mc) {
        int yOffset = baseOffset + 6;
        int xOffset = screenWidth / 2 - 91;
        Minecraft.m_91087_().m_91307_().m_6180_("BossBar");
        pGuiGraphics.m_280163_(this.getTexture(), xOffset, yOffset, 0.0f, 0.0f, 183, 24, 256, 64);
        int i = (int)(this.getPercentage() * 177.0f);
        if (i > 0) {
            Col color = this.isRainbow() ? Col.rainbow((float)((float)mc.f_91073_.m_46467_() / 1.5f)) : this.getColor();
            pGuiGraphics.m_280246_(color.r, color.g, color.b, 1.0f);
            pGuiGraphics.m_280163_(this.getTexture(), xOffset + 3, yOffset + 14, 3.0f, 30.0f, i, 4, 256, 64);
        }
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

