/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.menus;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.MenuRegistry;
import com.idark.valoria.registries.item.recipe.WorkbenchRecipe;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import pro.komaru.tridot.client.render.gui.screen.ContainerMenuBase;

public class HeavyWorkbenchMenu
extends ContainerMenuBase {
    private final Player player;
    private final Level level;
    private final ContainerLevelAccess access;
    public final List<WorkbenchRecipe> allRecipes;

    public HeavyWorkbenchMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public HeavyWorkbenchMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public HeavyWorkbenchMenu(int windowId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)MenuRegistry.HEAVY_WORKBENCH.get(), windowId);
        this.player = playerInventory.f_35978_;
        this.level = playerInventory.f_35978_.m_9236_();
        this.access = access;
        this.allRecipes = this.level.m_7465_().m_44013_((RecipeType)WorkbenchRecipe.Type.INSTANCE);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 114 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 172));
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<WorkbenchRecipe> getAllRecipes() {
        return this.allRecipes;
    }

    public boolean m_6875_(Player pPlayer) {
        return HeavyWorkbenchMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)BlockRegistry.heavyWorkbench.get()));
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean checkAndSetAvailability(WorkbenchRecipe recipe) {
        Inventory inv = this.player.m_150109_();
        boolean isEnough = true;
        for (Pair<Ingredient, WorkbenchRecipe.RecipeData> entry : recipe.getInputs()) {
            Ingredient ingredient = (Ingredient)entry.getFirst();
            int requiredCount = ((WorkbenchRecipe.RecipeData)entry.getSecond()).count;
            int currentCount = 0;
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                currentCount += stack.m_41613_();
            }
            ((WorkbenchRecipe.RecipeData)entry.getSecond()).setCurrent(currentCount);
            ((WorkbenchRecipe.RecipeData)entry.getSecond()).setEnough(currentCount >= requiredCount);
            if (((WorkbenchRecipe.RecipeData)entry.getSecond()).isEnough) continue;
            isEnough = false;
        }
        return isEnough;
    }

    private void consumeMaterials(WorkbenchRecipe recipe) {
        Inventory inv = this.player.m_150109_();
        for (Pair<Ingredient, WorkbenchRecipe.RecipeData> entry : recipe.getInputs()) {
            Ingredient ingredient = (Ingredient)entry.getFirst();
            int requiredCount = ((WorkbenchRecipe.RecipeData)entry.getSecond()).count;
            for (int i = 0; i < inv.m_6643_() && requiredCount > 0; ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                int consumeAmount = Math.min(requiredCount, stack.m_41613_());
                stack.m_41774_(consumeAmount);
                requiredCount -= consumeAmount;
            }
        }
    }

    public void tryCraftRecipe(ServerPlayer player, ResourceLocation recipeId) {
        WorkbenchRecipe recipe;
        Optional<WorkbenchRecipe> recipeHolder = this.level.m_7465_().m_44043_(recipeId).filter(r -> r instanceof WorkbenchRecipe).map(r -> (WorkbenchRecipe)r);
        if (recipeHolder.isPresent() && this.checkAndSetAvailability(recipe = recipeHolder.get())) {
            this.consumeMaterials(recipe);
            ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
            player.m_150109_().m_150079_(result);
            this.m_38946_();
        }
    }
}

