/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.ui.menus.HeavyWorkbenchMenu;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.HeavyWorkbenchCraftPacket;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.component.MaterialListComponent;
import com.idark.valoria.registries.item.recipe.WorkbenchRecipe;
import com.idark.valoria.util.ValoriaUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import pro.komaru.tridot.util.phys.AbsRect;
import pro.komaru.tridot.util.struct.data.Seq;

public class HeavyWorkbenchScreen
extends AbstractContainerScreen<HeavyWorkbenchMenu> {
    private static final ResourceLocation TEXTURE = Valoria.loc("textures/gui/container/heavy_workbench.png");
    private final Seq<BlueprintData> renderedRecipes = Seq.with();
    private BlueprintData hoveredRecipe = null;
    private BlueprintData clickedBlueprintO;
    private long lastClickTime = 0L;
    private final int blueprintAreaLeft = 10;
    private final int blueprintAreaTop = 6;
    private final int blueprintAreaWidth = 44;
    private final int blueprintAreaHeight = 29;
    private final int scrollbarHeight = 84;
    private float scrollDistance = 0.0f;
    private final int visible = 3;
    private final int recipeAreaWidth = 174;
    private final int recipeAreaHeight = 94;
    private final int gridXOffset = 6;
    private final int gridYOffset = 2;
    private final int recipeRowHeight = this.blueprintAreaHeight + this.gridYOffset;
    private final ContainerListener listener = new ContainerListener(){

        public void m_7934_(AbstractContainerMenu menu, int index, ItemStack stack) {
            HeavyWorkbenchScreen.this.updateCraftableRecipes();
        }

        public void m_142153_(AbstractContainerMenu menu, int index, int value) {
        }
    };

    public HeavyWorkbenchScreen(HeavyWorkbenchMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97727_ = 196;
        this.f_97726_ = 176;
        ((HeavyWorkbenchMenu)this.f_97732_).m_38893_(this.listener);
    }

    public void m_7861_() {
        super.m_7861_();
        ((HeavyWorkbenchMenu)this.f_97732_).m_38943_(this.listener);
    }

    public void updateCraftableRecipes() {
        Seq craftableRecipes = Seq.with();
        Seq nonCraftableRecipes = Seq.with();
        for (WorkbenchRecipe recipeHolder : ((HeavyWorkbenchMenu)this.f_97732_).getAllRecipes()) {
            BlueprintData data = new BlueprintData(recipeHolder);
            if (((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(recipeHolder)) {
                craftableRecipes.add((Object)data);
                continue;
            }
            nonCraftableRecipes.add((Object)data);
        }
        craftableRecipes.sort(Comparator.comparing(b -> b.recipe.m_6423_()));
        nonCraftableRecipes.sort(Comparator.comparing(b -> b.recipe.m_6423_()));
        this.renderedRecipes.clear();
        this.renderedRecipes.addAll(craftableRecipes).addAll(nonCraftableRecipes);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hoveredRecipe = this.getBlueprintAt(mouseX, mouseY);
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 30, 0x404040, false);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.hoveredRecipe != null && this.hoveredRecipe.isVisible()) {
            WorkbenchRecipe recipe = this.hoveredRecipe.recipe;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            Optional<Object> comp = Optional.empty();
            ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
            tooltip.add(result.m_41786_().m_6881_().m_130948_(result.m_41611_().m_7383_()));
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237110_((String)"tooltip.tridot.shift_for_details", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.shift").getString()}).m_130940_(ChatFormatting.GRAY));
            if (!recipe.getInputs().isEmpty()) {
                comp = Optional.of(new MaterialListComponent(recipe.getInputs()));
            }
            if (!Screen.m_96638_()) {
                guiGraphics.m_280677_(this.f_96547_, tooltip, comp, mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.f_96547_, result.m_41651_(null, (TooltipFlag)TooltipFlag.f_256752_), Optional.empty(), result, mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(GuiGraphics gui, float partialTick, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int scrollbarTop = top + 8;
        int scrollbarLeft = left + 163;
        gui.m_280218_(TEXTURE, left, top, 0, 0, this.f_97726_, this.f_97727_);
        gui.m_280218_(TEXTURE, scrollbarLeft, scrollbarTop, 176, 0, 7, 84);
        int maxScroll = this.getMaxScroll();
        float scrollPercentage = maxScroll > 0 ? this.scrollDistance / (float)maxScroll : 0.0f;
        int scrollbarThumbY = (int)(scrollPercentage * 74.0f);
        gui.m_280218_(TEXTURE, scrollbarLeft, scrollbarTop + scrollbarThumbY, 183, 0, 7, 15);
        int recipeAreaX = this.getRecipeAreaX(left);
        int recipeAreaY = this.getRecipeAreaY(top);
        this.scissorsOn(gui, gui.m_280168_(), recipeAreaX, recipeAreaY + 19, this.recipeAreaWidth, this.recipeAreaHeight);
        this.renderGrid(gui, left, top);
        this.scissorsOff(gui);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 180.0f);
        if (this.scrollDistance > 0.0f) {
            gui.m_280024_(left + 3, top + 3, left + 173, top + 25, new Color(0.0f, 0.0f, 0.0f, 0.45f).getRGB(), new Color(1, 0, 0, 0).getRGB());
        }
        if (this.scrollDistance < (float)maxScroll) {
            gui.m_280024_(left + 3, top + 80, left + 173, top + 98, new Color(1, 0, 0, 0).getRGB(), new Color(0.0f, 0.0f, 0.0f, 0.45f).getRGB());
        }
        gui.m_280168_().m_85849_();
    }

    public boolean isVisible(GuiGraphics gui, int x, int y) {
        return ValoriaUtils.isVisibleInScissor(gui, x, y, 44, 29, this.getRecipeAreaX(this.getGuiLeft()), this.getRecipeAreaY(this.getGuiTop()), 174, 84);
    }

    private void renderGrid(GuiGraphics gui, int left, int top) {
        for (int i = 0; i < this.renderedRecipes.size; ++i) {
            int row = i / this.visible;
            int col = i % this.visible;
            BlueprintData blueprintData = (BlueprintData)this.renderedRecipes.get(i);
            WorkbenchRecipe recipe = blueprintData.recipe;
            Objects.requireNonNull(this);
            int x = left + this.blueprintAreaLeft + col * (this.blueprintAreaWidth + 6);
            Objects.requireNonNull(this);
            int y = top + 6 + row * this.recipeRowHeight - (int)this.scrollDistance;
            if (this.isVisible(gui, x, y)) {
                blueprintData.setVisible(true);
                if (this.hoveredRecipe != null && recipe.equals(this.hoveredRecipe.recipe)) {
                    gui.m_280218_(TEXTURE, x - 1, y - 1, 0, 196 + this.blueprintAreaHeight, this.blueprintAreaWidth + 2, this.blueprintAreaHeight + 2);
                }
                gui.m_280218_(TEXTURE, x, y, ((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(recipe) ? 0 : 44, 196, this.blueprintAreaWidth, this.blueprintAreaHeight);
                ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                gui.m_280203_(result, x + 14, y + 6);
                continue;
            }
            blueprintData.setVisible(false);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            this.scrollDistance = Mth.m_14036_((float)(this.scrollDistance - (float)delta * (float)this.recipeRowHeight), (float)0.0f, (float)maxScroll);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        BlueprintData clickedBlueprint = this.hoveredRecipe;
        if (button == 0) {
            if (clickedBlueprint != null && clickedBlueprint.isVisible()) {
                if (this.clickedBlueprintO == clickedBlueprint && ((HeavyWorkbenchMenu)this.f_97732_).checkAndSetAvailability(clickedBlueprint.recipe) && System.currentTimeMillis() - this.lastClickTime < 450L) {
                    this.f_96541_.f_91074_.m_216990_((SoundEvent)SoundsRegistry.CRYSTAL_ACID.get());
                    PacketHandler.sendToServer(new HeavyWorkbenchCraftPacket(this.hoveredRecipe.recipe));
                    this.lastClickTime = 0L;
                    return true;
                }
                this.clickedBlueprintO = this.hoveredRecipe;
                this.lastClickTime = System.currentTimeMillis();
                this.f_96541_.f_91074_.m_216990_((SoundEvent)SoundsRegistry.UI_CLICK.get());
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void scissorsOn(GuiGraphics gui, PoseStack pose, int x, int y, int w, int h) {
        AbsRect r = AbsRect.xywhDef((float)x, (float)y, (float)w, (float)h).pose(pose);
        gui.m_280588_((int)r.x, (int)r.y, (int)r.x2, (int)r.y2);
    }

    public void scissorsOff(GuiGraphics gui) {
        gui.m_280618_();
    }

    private BlueprintData getBlueprintAt(double mouseX, double mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int mouseXRelative = (int)mouseX - left;
        int mouseYRelative = (int)mouseY - top;
        int viewportX = this.blueprintAreaLeft;
        Objects.requireNonNull(this);
        int viewportY = 6;
        Objects.requireNonNull(this);
        int viewportWidth = this.visible * (this.blueprintAreaWidth + 6);
        if (mouseXRelative < viewportX || mouseXRelative >= viewportX + viewportWidth || mouseYRelative < viewportY || mouseYRelative >= viewportY + this.recipeAreaHeight) {
            return null;
        }
        for (int i = 0; i < this.renderedRecipes.size; ++i) {
            int row = i / this.visible;
            int col = i % this.visible;
            Objects.requireNonNull(this);
            int itemX = this.blueprintAreaLeft + col * (this.blueprintAreaWidth + 6);
            Objects.requireNonNull(this);
            int itemY = 6 + row * this.recipeRowHeight - (int)this.scrollDistance;
            if (mouseXRelative < itemX || mouseXRelative >= itemX + this.blueprintAreaWidth || mouseYRelative < itemY || mouseYRelative >= itemY + this.blueprintAreaHeight) continue;
            return (BlueprintData)this.renderedRecipes.get(i);
        }
        return null;
    }

    public int getMaxScroll() {
        int totalContentHeight = (int)Math.ceil((double)this.renderedRecipes.size / (double)this.visible) * this.recipeRowHeight;
        return Math.max(0, totalContentHeight - this.recipeAreaHeight);
    }

    public int getRecipeAreaY(int top) {
        return top + 33;
    }

    public int getRecipeAreaX(int left) {
        return left + 88;
    }

    public static class BlueprintData {
        private final WorkbenchRecipe recipe;
        private boolean visible = true;

        public BlueprintData(WorkbenchRecipe recipe) {
            this.recipe = recipe;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

