/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.pages;

import com.idark.valoria.client.ui.screen.book.BookGui;
import com.idark.valoria.client.ui.screen.book.Page;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.joml.Quaternionf;
import pro.komaru.tridot.client.ClientTick;

public class TextPage
extends Page {
    public String text;
    public String title;
    public boolean hasTitle = true;
    public static final ResourceLocation BACKGROUND = new ResourceLocation("valoria", "textures/gui/book/codex.png");
    public ItemStack result;
    public Ingredient[] inputs;
    private boolean hasRecipe = false;
    @Nullable
    public LivingEntity entity;
    @Nullable
    public EntityType<? extends LivingEntity> type;
    public int entityX;
    public int entityY = 0;
    public int recipeX = 21;
    public int recipeY = 34;
    public int entityScale = 25;
    public boolean isDark = false;
    public static final Quaternionf ENTITY_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);

    public TextPage(String textKey) {
        this.text = textKey;
        this.title = textKey + ".name";
    }

    public TextPage withEntity(EntityType<? extends LivingEntity> type) {
        this.type = type;
        return this;
    }

    public TextPage setCraftData(int x, int y) {
        this.recipeX = x;
        this.recipeY = y;
        return this;
    }

    public TextPage setEntityData(int x, int y, int scale, boolean dark) {
        this.entityX = x;
        this.entityY = y;
        this.entityScale = scale;
        this.isDark = dark;
        return this;
    }

    public TextPage setEntityData(int x, int y, int scale) {
        this.entityX = x;
        this.entityY = y;
        this.entityScale = scale;
        return this;
    }

    public TextPage hideTitle() {
        this.hasTitle = false;
        return this;
    }

    public TextPage withCustomTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public void init() {
        super.init();
        if (FMLEnvironment.dist.isClient() && this.result != null && this.result.m_41720_() != Items.f_41852_) {
            RecipeManager manager;
            Optional<Recipe> optional;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && (optional = (manager = mc.f_91073_.m_7465_()).m_44051_().stream().filter(r -> ItemStack.m_41656_((ItemStack)r.m_8043_(mc.f_91073_.m_9598_()), (ItemStack)this.result)).findFirst()).isPresent()) {
                Recipe recipe = optional.get();
                NonNullList ingredients = recipe.m_7527_();
                this.inputs = (Ingredient[])ingredients.toArray(Ingredient[]::new);
                this.hasRecipe = true;
            }
        }
    }

    public TextPage withCraftEntry(ItemStack result) {
        this.result = result;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y, int mouseX, int mouseY) {
        int yOffset = 13;
        if (this.hasTitle) {
            int n = x + (120 - Minecraft.m_91087_().f_91062_.m_92895_(I18n.m_118938_((String)this.title, (Object[])new Object[0]))) / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            TextPage.drawText(gui, this.title, n, y + 22 - 9, false);
            yOffset += 16;
        }
        TextPage.drawWrappingText(gui, I18n.m_118938_((String)this.text, (Object[])new Object[0]), x + 3, y + yOffset, 120, false);
        if (this.hasRecipe) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Ingredient ingredient;
                    ItemStack[] matchingStacks;
                    int index = i * 3 + j;
                    if (index < this.inputs.length && (matchingStacks = (ingredient = this.inputs[index]).m_43908_()).length > 0) {
                        int cycle = ClientTick.ticksInGame / 40 % matchingStacks.length;
                        ItemStack display = matchingStacks[cycle];
                        BookGui.drawItemWithTooltip(display, x + 22 + j * 18, y + 35 + i * 18 + 50, gui, mouseX, mouseY, true);
                    }
                    gui.m_280163_(BACKGROUND, x + this.recipeX + j * 18, y + this.recipeY + i * 18 + 50, 287.0f, 15.0f, 18, 18, 512, 512);
                }
            }
            gui.m_280163_(BACKGROUND, x + 88, y + 56 + 46, 287.0f, 15.0f, 18, 18, 512, 512);
            BookGui.drawItemWithTooltip(this.result, x + 89, y + 57 + 46, gui, mouseX, mouseY, true);
            this.resultArrow(gui, x, y);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (this.type != null) {
            this.renderEntity(this.isDark, gui, this.type, x, y, this.entityScale, mc, yOffset);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderEntity(boolean isDark, GuiGraphics gui, EntityType<? extends LivingEntity> type, int x, int y, int scale, Minecraft mc, int yOffset) {
        this.entity = (LivingEntity)type.m_20615_((Level)mc.f_91073_);
        if (this.entity != null) {
            this.entity.m_5618_(210.0f);
            this.entity.m_5616_(210.0f);
            if (isDark) {
                gui.m_280246_(0.0f, 0.0f, 0.0f, 1.0f);
                InventoryScreen.m_280432_((GuiGraphics)gui, (int)(x + this.entityX), (int)(y + this.entityY + yOffset), (int)scale, (Quaternionf)ENTITY_ANGLE, null, (LivingEntity)this.entity);
                gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                InventoryScreen.m_280432_((GuiGraphics)gui, (int)(x + this.entityX), (int)(y + this.entityY + yOffset), (int)scale, (Quaternionf)ENTITY_ANGLE, null, (LivingEntity)this.entity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resultArrow(GuiGraphics gui, int x, int y) {
        gui.m_280163_(BACKGROUND, x + 77, y + 107, 306.0f, 15.0f, 9, 7, 512, 512);
    }
}

