/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.compat.jade;

import com.idark.valoria.core.compat.jade.ModPlugin;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.block.entity.KegBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ProgressArrowElement;

public enum KegProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!data.m_128441_("progress")) {
            return;
        }
        KegBlockEntity kegBlock = (KegBlockEntity)accessor.getBlockEntity();
        ItemStack itemStack = kegBlock.itemOutputHandler.getStackInSlot(0);
        int progress = data.m_128451_("progress");
        int total = data.m_128451_("total");
        tooltip.append((IElement)new ProgressArrowElement((float)progress / (float)total));
        IElementHelper elements = tooltip.getElementHelper();
        IElement icon = elements.item(new ItemStack((ItemLike)Items.f_42524_), 0.5f).size(new Vec2(11.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f));
        icon.message(null);
        tooltip.add(icon);
        tooltip.append((Component)Component.m_237115_((String)"valoria.jade.progress"));
        tooltip.append((Component)Component.m_237113_((String)(" " + progress + "/" + total)));
        if (!itemStack.m_41619_()) {
            if (itemStack.m_204117_(TagsRegistry.CUP_DRINKS)) {
                IElement cup = elements.item(new ItemStack((ItemLike)ItemsRegistry.woodenCup.get()), 0.75f).size(new Vec2(11.0f, 0.0f)).translate(new Vec2(0.0f, -26.0f));
                cup.message(null);
                cup.align(IElement.Align.RIGHT);
                tooltip.add(cup);
            }
            if (itemStack.m_204117_(TagsRegistry.BOTTLE_DRINKS)) {
                IElement bottle = elements.item(new ItemStack((ItemLike)ItemsRegistry.bottle.get()), 0.75f).size(new Vec2(11.0f, 0.0f)).translate(new Vec2(0.0f, -26.0f));
                bottle.message(null);
                bottle.align(IElement.Align.RIGHT);
                tooltip.add(bottle);
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        KegBlockEntity kegBlock = (KegBlockEntity)accessor.getBlockEntity();
        if (!kegBlock.itemHandler.getStackInSlot(0).m_41619_()) {
            ListTag items = new ListTag();
            items.add((Object)kegBlock.itemHandler.getStackInSlot(0).m_41739_(new CompoundTag()));
            data.m_128365_("kegBlock", (Tag)items);
        }
        data.m_128405_("progress", kegBlock.progress);
        data.m_128405_("total", kegBlock.progressMax);
    }

    public ResourceLocation getUid() {
        return ModPlugin.KEG;
    }
}

