/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.compat.jade;

import com.idark.valoria.core.compat.jade.CrusherProvider;
import com.idark.valoria.core.compat.jade.JewelryProvider;
import com.idark.valoria.core.compat.jade.KegProvider;
import com.idark.valoria.core.compat.jade.KeyBlockProvider;
import com.idark.valoria.core.compat.jade.ManipulatorProvider;
import com.idark.valoria.core.compat.jade.TieredToolHandler;
import com.idark.valoria.registries.ItemTierRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.registries.block.entity.CrusherBlockEntity;
import com.idark.valoria.registries.block.entity.JewelryBlockEntity;
import com.idark.valoria.registries.block.entity.KegBlockEntity;
import com.idark.valoria.registries.block.entity.ManipulatorBlockEntity;
import com.idark.valoria.registries.block.types.CrusherBlock;
import com.idark.valoria.registries.block.types.JewelerBlock;
import com.idark.valoria.registries.block.types.KegBlock;
import com.idark.valoria.registries.block.types.ManipulatorBlock;
import com.idark.valoria.registries.block.types.UmbralKeyPadBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin
public class ModPlugin
implements IWailaPlugin {
    public static final ResourceLocation JEWELRY = new ResourceLocation("valoria:jewelry");
    public static final ResourceLocation CRUSHER = new ResourceLocation("valoria:crusher");
    public static final ResourceLocation KEG = new ResourceLocation("valoria:keg");
    public static final ResourceLocation KEY = new ResourceLocation("valoria:key");
    public static final ResourceLocation MANIPULATOR = new ResourceLocation("valoria:manipulator");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)JewelryProvider.INSTANCE, JewelryBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)CrusherProvider.INSTANCE, CrusherBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)KegProvider.INSTANCE, KegBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)ManipulatorProvider.INSTANCE, ManipulatorBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)JewelryProvider.INSTANCE, JewelerBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)CrusherProvider.INSTANCE, CrusherBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)KegProvider.INSTANCE, KegBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)KeyBlockProvider.INSTANCE, UmbralKeyPadBlock.class);
        registration.registerBlockComponent((IBlockComponentProvider)ManipulatorProvider.INSTANCE, ManipulatorBlock.class);
        this.registerTier("bronze", TagsRegistry.NEEDS_BRONZE_TOOL, ItemTierRegistry.BRONZE);
        this.registerTier("pearlium", TagsRegistry.NEEDS_PEARLIUM_TOOL, ItemTierRegistry.PEARLIUM);
        this.registerTier("cobalt", TagsRegistry.NEEDS_COBALT_TOOL, ItemTierRegistry.COBALT);
        this.registerTier("ethereal", TagsRegistry.NEEDS_ETHEREAL_TOOL, ItemTierRegistry.ETHEREAL);
        this.registerTier("nature", TagsRegistry.NEEDS_NATURE_TOOL, ItemTierRegistry.NATURE);
        this.registerTier("aquarius", TagsRegistry.NEEDS_DEPTH_TOOL, ItemTierRegistry.AQUARIUS);
        this.registerTier("infernal", TagsRegistry.NEEDS_INFERNAL_TOOL, ItemTierRegistry.INFERNAL);
        this.registerTier("jade", TagsRegistry.NEEDS_JADE_TOOL, ItemTierRegistry.JADE);
        this.registerTier("void", TagsRegistry.NEEDS_VOID_TOOL, ItemTierRegistry.NIHILITY);
    }

    public void registerTier(String name, TagKey<Block> tag, Tier tier) {
        HarvestToolProvider.registerHandler((ToolHandler)new TieredToolHandler(name, tag, tier, () -> ItemTierRegistry.getTieredItems(tier)));
    }
}

