/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.compat.jei.jer;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.level.LevelGen;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IJERAPI;
import jeresources.api.IMobRegistry;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.JERPlugin;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.api.JERAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;

@JERPlugin
public class JerCompat {
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        IMobRegistry mobRegistry;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel clientLevel = mc.f_91073_;
        if (clientLevel != null && (mobRegistry = JERAPI.getInstance().getMobRegistry()) != null) {
            mobRegistry.register((LivingEntity)((EntityType)EntityTypeRegistry.WICKED_CRYSTAL.get()).m_20615_((Level)clientLevel), new ResourceLocation("valoria", "items/wicked_crystal_treasure_bag"));
            mobRegistry.register((LivingEntity)((EntityType)EntityTypeRegistry.DRYADOR.get()).m_20615_((Level)clientLevel), new ResourceLocation("valoria", "items/dryador_treasure_bag"));
            mobRegistry.register((LivingEntity)((EntityType)EntityTypeRegistry.NECROMANCER.get()).m_20615_((Level)clientLevel), new ResourceLocation("valoria", "items/necromancer_treasure_bag"));
        }
    }

    public static void init() {
        IJERAPI jerApi = JERAPI.getInstance();
        IDungeonRegistry dungeonRegistry = jerApi.getDungeonRegistry();
        IWorldGenRegistry worldGenRegistry = JERAPI.getInstance().getWorldGenRegistry();
        if (worldGenRegistry != null) {
            JerCompat.oreRegistry(worldGenRegistry);
        }
        if (dungeonRegistry != null) {
            JerCompat.dungeonRegistry(dungeonRegistry);
        }
    }

    private static void oreRegistry(IWorldGenRegistry worldGenRegistry) {
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.sapphireOre.get()), new ItemStack((ItemLike)BlockRegistry.deepslateSapphireOre.get()), (DistributionBase)new DistributionSquare(3, 4, -64, 16), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.sapphireGem.get()), 2, 5, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.pearliumOre.get()), (DistributionBase)new DistributionSquare(7, 14, -64, 42), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.pearliumIngot.get()), 2, 5, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.cobaltOre.get()), new ItemStack((ItemLike)BlockRegistry.deepslateCobaltOre.get()), (DistributionBase)new DistributionSquare(4, 8, -64, 6), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.rawCobalt.get()), 1, 1, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.amberOre.get()), new ItemStack((ItemLike)BlockRegistry.deepslateAmberOre.get()), (DistributionBase)new DistributionSquare(3, 4, -64, 32), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.amberGem.get()), 2, 5, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.rubyOre.get()), new ItemStack((ItemLike)BlockRegistry.deepslateRubyOre.get()), (DistributionBase)new DistributionSquare(2, 4, -64, 8), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.rubyGem.get()), 2, 5, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.jadeOre.get()), new ItemStack((ItemLike)BlockRegistry.picriteJadeOre.get()), (DistributionBase)new DistributionSquare(6, 3, -64, 6), new Restriction(new DimensionRestriction(LevelGen.VALORIA_KEY)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.jade.get()), 2, 5, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.pyratiteOre.get()), (DistributionBase)new DistributionSquare(6, 5, -64, 32), new Restriction(new DimensionRestriction(LevelGen.VALORIA_KEY)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.pyratite.get()), 1, 1, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.wickedAmethystOre.get()), (DistributionBase)new DistributionSquare(8, 14, -64, 42), new Restriction(new DimensionRestriction(LevelGen.VALORIA_KEY)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.wickedAmethyst.get()), 1, 3, new Conditional[]{Conditional.affectedByFortune})});
        worldGenRegistry.register(new ItemStack((ItemLike)BlockRegistry.dormantCrystals.get()), (DistributionBase)new DistributionSquare(6, 8, -64, 42), new Restriction(new DimensionRestriction(LevelGen.VALORIA_KEY)), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)ItemsRegistry.unchargedShard.get()), 1, 3, new Conditional[]{Conditional.affectedByFortune})});
    }

    private static void dungeonRegistry(IDungeonRegistry dungeonRegistry) {
        dungeonRegistry.registerChest("Fortress", new ResourceLocation("valoria", "chests/fortress"));
        dungeonRegistry.registerChest("Fortress Good", new ResourceLocation("valoria", "chests/fortress_good"));
        dungeonRegistry.registerChest("Fortress Normal", new ResourceLocation("valoria", "chests/fortress_normal"));
        dungeonRegistry.registerChest("Crypt", new ResourceLocation("valoria", "chests/crypt"));
        dungeonRegistry.registerChest("Crypt Sarcophagus", new ResourceLocation("valoria", "items/sarcophagus"));
        dungeonRegistry.registerChest("Necromancer Crypt", new ResourceLocation("valoria", "chests/necromancer_crypt"));
        dungeonRegistry.registerChest("Crystallized Deep Ruins", new ResourceLocation("valoria", "chests/crystallized_deep_ruins"));
        dungeonRegistry.registerChest("Fractured Skull", new ResourceLocation("valoria", "chests/fractured_skull"));
        dungeonRegistry.registerChest("Monstrosity", new ResourceLocation("valoria", "chests/monstrosity"));
    }
}

