/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.interfaces;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.block.types.BloodVeinBlock;
import com.idark.valoria.registries.block.types.FleshSpreader;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import pro.komaru.tridot.util.Tmp;

public interface FleshSpreaderBehaviour {
    public static final FleshSpreaderBehaviour DEFAULT = new FleshSpreaderBehaviour(){

        @Override
        public boolean attemptSpreadVein(LevelAccessor p_222048_, BlockPos p_222049_, BlockState p_222050_, @Nullable Collection<Direction> p_222051_, boolean p_222052_) {
            if (Tmp.rnd.chance(0.25f)) {
                if (p_222051_ == null) {
                    return ((BloodVeinBlock)BlockRegistry.bloodVein.get()).getSameSpaceSpreader().m_221657_(p_222048_.m_8055_(p_222049_), p_222048_, p_222049_, p_222052_) > 0L;
                }
                if (!p_222051_.isEmpty()) {
                    return (p_222050_.m_60795_() || p_222050_.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) && BloodVeinBlock.regrow(p_222048_, p_222049_, p_222050_, p_222051_);
                }
                return FleshSpreaderBehaviour.super.attemptSpreadVein(p_222048_, p_222049_, p_222050_, p_222051_, p_222052_);
            }
            return false;
        }

        @Override
        public int attemptUseCharge(FleshSpreader.ChargeCursor p_222054_, LevelAccessor p_222055_, BlockPos p_222056_, RandomSource p_222057_, FleshSpreader p_222058_, boolean p_222059_) {
            return p_222054_.getDecayDelay() > 0 ? p_222054_.getCharge() : 0;
        }

        @Override
        public int updateDecayDelay(int p_222061_) {
            return Math.max(p_222061_ - 1, 0);
        }
    };

    default public byte getSpreadDelay() {
        return 1;
    }

    default public void onDischarged(LevelAccessor pLevel, BlockState pState, BlockPos pPos, RandomSource pRandom) {
    }

    default public boolean depositCharge(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        return false;
    }

    default public boolean attemptSpreadVein(LevelAccessor pLevel, BlockPos pPos, BlockState pState, @Nullable Collection<Direction> pDirections, boolean pMarkForPostprocessing) {
        return ((MultifaceBlock)BlockRegistry.bloodVein.get()).m_213612_().m_221657_(pState, pLevel, pPos, pMarkForPostprocessing) > 0L;
    }

    default public boolean canChangeBlockStateOnSpread() {
        return true;
    }

    default public int updateDecayDelay(int pCurrentDecayDelay) {
        return 1;
    }

    public int attemptUseCharge(FleshSpreader.ChargeCursor var1, LevelAccessor var2, BlockPos var3, RandomSource var4, FleshSpreader var5, boolean var6);
}

