/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.api.unlockable.Unlockables;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.core.loot.conditions.LootConditionsRegistry;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class UnlockableCondition
implements LootItemCondition {
    public final String id;

    UnlockableCondition(String id) {
        this.id = id;
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)LootConditionsRegistry.UNLOCKABLE_CONDITION.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        if (entity instanceof Player) {
            Player plr = (Player)entity;
            Unlockable unlockable = Unlockables.getUnlockable(this.id);
            return !UnlockUtils.isUnlocked(plr, unlockable);
        }
        return false;
    }

    public static Builder unlockable(String id) {
        return new Builder(id);
    }

    public record Builder(String id) implements LootItemCondition.Builder
    {
        public UnlockableCondition build() {
            return new UnlockableCondition(this.id);
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<UnlockableCondition> {
        public void serialize(JsonObject json, UnlockableCondition condition, JsonSerializationContext context) {
            json.add("id", context.serialize((Object)condition.id));
        }

        public UnlockableCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String id = (String)GsonHelper.m_13836_((JsonObject)json, (String)"id", (JsonDeserializationContext)context, String.class);
            return new UnlockableCondition(id);
        }
    }
}

