/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.mixin.client;

import com.idark.valoria.client.ValoriaLayers;
import com.idark.valoria.client.model.curio.HandsModelSlim;
import com.idark.valoria.registries.item.types.curio.ICurioTexture;
import com.idark.valoria.registries.item.types.curio.hands.DyeableGlovesItem;
import com.idark.valoria.registries.item.types.curio.hands.GlovesItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Shadow
    protected abstract void m_7523_(AbstractClientPlayer var1, PoseStack var2, float var3, float var4, float var5);

    @Shadow
    protected abstract void m_117818_(AbstractClientPlayer var1);

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(context, model, shadowRadius);
    }

    @Unique
    public float[] valoria$getColor(ItemStack stack) {
        if (stack.m_41720_() instanceof DyeableGlovesItem) {
            int color = ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new float[]{r, g, b};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")})
    private void valoria$renderHand(PoseStack pPose, MultiBufferSource pBuffer, int pLight, AbstractClientPlayer pPlayer, ModelPart pArm, ModelPart pWear, CallbackInfo ci) {
        List curioSlots = CuriosApi.getCuriosHelper().findCurios((LivingEntity)pPlayer, i -> true);
        for (SlotResult slot : curioSlots) {
            ICurioTexture item;
            Item item2;
            if (!slot.slotContext().cosmetic() && !slot.slotContext().visible() || !((item2 = slot.stack().m_41720_()) instanceof ICurioTexture) || !((item = (ICurioTexture)item2) instanceof GlovesItem)) continue;
            float[] color = this.valoria$getColor(slot.stack());
            PlayerModel playerModel = (PlayerModel)this.m_7200_();
            this.m_117818_(pPlayer);
            playerModel.f_102608_ = 0.0f;
            playerModel.f_102817_ = false;
            playerModel.f_102818_ = 0.0f;
            playerModel.m_6973_((LivingEntity)pPlayer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            pArm.f_104203_ = 0.0f;
            ModelLayerLocation pRenderLayer = playerModel.f_103380_ ? ValoriaLayers.HANDS_LAYER_SLIM : ValoriaLayers.HANDS_LAYER;
            ResourceLocation pTexture = item.getTexture(slot.stack(), (LivingEntity)pPlayer);
            if (pRenderLayer == null || pTexture == null) {
                return;
            }
            HandsModelSlim pModel = new HandsModelSlim(Minecraft.m_91087_().m_167973_().m_171103_(pRenderLayer));
            if (pArm == playerModel.f_102811_) {
                pModel.right_glove.m_104315_(pArm);
                pModel.right_glove.m_104306_(pPose, pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)pTexture)), pLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
                continue;
            }
            pModel.left_glove.m_104315_(pArm);
            pModel.left_glove.m_104306_(pPose, pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)pTexture)), pLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        }
    }
}

