/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network;

import com.idark.valoria.core.network.packets.CuriosSetStackPacket;
import com.idark.valoria.core.network.packets.HeavyWorkbenchCraftPacket;
import com.idark.valoria.core.network.packets.MusicToastPacket;
import com.idark.valoria.core.network.packets.NihilityPacket;
import com.idark.valoria.core.network.packets.PageToastPacket;
import com.idark.valoria.core.network.packets.UnlockCodexPacket;
import com.idark.valoria.core.network.packets.UnlockableUpdatePacket;
import com.idark.valoria.core.network.packets.particle.BeastAttackParticlePacket;
import com.idark.valoria.core.network.packets.particle.CircleShapedParticlePacket;
import com.idark.valoria.core.network.packets.particle.CubeShapedParticlePacket;
import com.idark.valoria.core.network.packets.particle.CystSummonParticlePacket;
import com.idark.valoria.core.network.packets.particle.DashParticlePacket;
import com.idark.valoria.core.network.packets.particle.FireTrapParticlePacket;
import com.idark.valoria.core.network.packets.particle.KeypadParticlePacket;
import com.idark.valoria.core.network.packets.particle.LineToNearbyMobsParticlePacket;
import com.idark.valoria.core.network.packets.particle.ManipulatorCraftParticlePacket;
import com.idark.valoria.core.network.packets.particle.ManipulatorEmptyParticlePacket;
import com.idark.valoria.core.network.packets.particle.ManipulatorParticlePacket;
import com.idark.valoria.core.network.packets.particle.MinionSummonParticlePacket;
import com.idark.valoria.core.network.packets.particle.MurasamaParticlePacket;
import com.idark.valoria.core.network.packets.particle.ParticleLinePacket;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.core.network.packets.particle.SoulCollectParticlePacket;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class PacketHandler {
    private static final String PROTOCOL = "10";
    public static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("valoria", "network"), () -> "10", "10"::equals, "10"::equals);
    private static final PacketDistributor<Pair<Level, BlockPos>> TRACKING_CHUNK_AND_NEAR = new PacketDistributor((_d, pairSupplier) -> {
        Pair pair = (Pair)pairSupplier.get();
        Level level = (Level)pair.getFirst();
        BlockPos blockpos = (BlockPos)pair.getSecond();
        ChunkPos chunkpos = new ChunkPos(blockpos);
        return packet -> {
            List players = ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(chunkpos, false);
            for (ServerPlayer player : players) {
                if (!(player.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()) < 4096.0)) continue;
                player.f_8906_.m_9829_(packet);
            }
        };
    }, NetworkDirection.PLAY_TO_CLIENT);

    private PacketHandler() {
    }

    public static void init() {
        int id = 0;
        HANDLER.registerMessage(id++, BeastAttackParticlePacket.class, BeastAttackParticlePacket::encode, BeastAttackParticlePacket::decode, BeastAttackParticlePacket::handle);
        HANDLER.registerMessage(id++, CystSummonParticlePacket.class, CystSummonParticlePacket::encode, CystSummonParticlePacket::decode, CystSummonParticlePacket::handle);
        HANDLER.registerMessage(id++, MinionSummonParticlePacket.class, MinionSummonParticlePacket::encode, MinionSummonParticlePacket::decode, MinionSummonParticlePacket::handle);
        HANDLER.registerMessage(id++, SoulCollectParticlePacket.class, SoulCollectParticlePacket::encode, SoulCollectParticlePacket::decode, SoulCollectParticlePacket::handle);
        HANDLER.registerMessage(id++, UnlockableUpdatePacket.class, UnlockableUpdatePacket::encode, UnlockableUpdatePacket::decode, UnlockableUpdatePacket::handle);
        HANDLER.registerMessage(id++, PageToastPacket.class, PageToastPacket::encode, PageToastPacket::decode, PageToastPacket::handle);
        HANDLER.registerMessage(id++, LineToNearbyMobsParticlePacket.class, LineToNearbyMobsParticlePacket::encode, LineToNearbyMobsParticlePacket::decode, LineToNearbyMobsParticlePacket::handle);
        HANDLER.registerMessage(id++, CircleShapedParticlePacket.class, CircleShapedParticlePacket::encode, CircleShapedParticlePacket::decode, CircleShapedParticlePacket::handle);
        HANDLER.registerMessage(id++, CubeShapedParticlePacket.class, CubeShapedParticlePacket::encode, CubeShapedParticlePacket::decode, CubeShapedParticlePacket::handle);
        HANDLER.registerMessage(id++, ManipulatorCraftParticlePacket.class, ManipulatorCraftParticlePacket::encode, ManipulatorCraftParticlePacket::decode, ManipulatorCraftParticlePacket::handle);
        HANDLER.registerMessage(id++, ManipulatorEmptyParticlePacket.class, ManipulatorEmptyParticlePacket::encode, ManipulatorEmptyParticlePacket::decode, ManipulatorEmptyParticlePacket::handle);
        HANDLER.registerMessage(id++, MurasamaParticlePacket.class, MurasamaParticlePacket::encode, MurasamaParticlePacket::decode, MurasamaParticlePacket::handle);
        HANDLER.registerMessage(id++, SmokeParticlePacket.class, SmokeParticlePacket::encode, SmokeParticlePacket::decode, SmokeParticlePacket::handle);
        HANDLER.registerMessage(id++, FireTrapParticlePacket.class, FireTrapParticlePacket::encode, FireTrapParticlePacket::decode, FireTrapParticlePacket::handle);
        HANDLER.registerMessage(id++, KeypadParticlePacket.class, KeypadParticlePacket::encode, KeypadParticlePacket::decode, KeypadParticlePacket::handle);
        HANDLER.registerMessage(id++, ParticleLinePacket.class, ParticleLinePacket::encode, ParticleLinePacket::decode, ParticleLinePacket::handle);
        HANDLER.registerMessage(id++, CuriosSetStackPacket.class, CuriosSetStackPacket::encode, CuriosSetStackPacket::decode, CuriosSetStackPacket::handle);
        HANDLER.registerMessage(id++, DashParticlePacket.class, DashParticlePacket::encode, DashParticlePacket::decode, DashParticlePacket::handle);
        HANDLER.registerMessage(id++, MusicToastPacket.class, MusicToastPacket::encode, MusicToastPacket::decode, MusicToastPacket::handle);
        HANDLER.registerMessage(id++, UnlockCodexPacket.class, UnlockCodexPacket::encode, UnlockCodexPacket::decode, UnlockCodexPacket::handle);
        HANDLER.registerMessage(id++, NihilityPacket.class, NihilityPacket::encode, NihilityPacket::decode, NihilityPacket::handle);
        HANDLER.registerMessage(id++, ManipulatorParticlePacket.class, ManipulatorParticlePacket::encode, ManipulatorParticlePacket::decode, ManipulatorParticlePacket::handle);
        HANDLER.registerMessage(id++, HeavyWorkbenchCraftPacket.class, HeavyWorkbenchCraftPacket::encode, HeavyWorkbenchCraftPacket::decode, HeavyWorkbenchCraftPacket::handle);
    }

    public static void sendTo(ServerPlayer playerMP, Object toSend) {
        HANDLER.sendTo(toSend, playerMP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAll(Object message) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            PacketHandler.sendNonLocal(message, player);
        }
    }

    public static void sendNonLocal(Object msg, ServerPlayer player) {
        HANDLER.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendNonLocal(ServerPlayer playerMP, Object toSend) {
        if (playerMP.f_8924_.m_6982_() || !playerMP.m_36316_().getName().equals(playerMP.f_8924_.m_130009_())) {
            PacketHandler.sendTo(playerMP, toSend);
        }
    }

    public static void sendToTracking(Level world, BlockPos pos, Object msg) {
        HANDLER.send(TRACKING_CHUNK_AND_NEAR.with(() -> Pair.of((Object)world, (Object)pos)), msg);
    }

    public static void sendTo(Player entity, Object msg) {
        HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), msg);
    }

    public static void sendEntity(Player entity, Object msg) {
        HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public static void sendToServer(Object msg) {
        HANDLER.sendToServer(msg);
    }
}

