/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.api.unlockable.Unlockables;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.UnlockableUpdatePacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class UnlockCodexPacket {
    private final String unlockableId;

    public UnlockCodexPacket(String unlockableId) {
        this.unlockableId = unlockableId;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.unlockableId);
    }

    public static UnlockCodexPacket decode(FriendlyByteBuf buffer) {
        return new UnlockCodexPacket(buffer.m_130277_());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        Unlockable unlockable = Unlockables.unlockableMap.get(this.unlockableId);
        if (unlockable != null && player != null) {
            UnlockUtils.claim((Player)player, unlockable);
            unlockable.award(player);
            PacketHandler.sendTo(player, (Object)new UnlockableUpdatePacket((Player)player));
        }
        ctx.get().setPacketHandled(true);
    }
}

