/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.util.Pal;
import java.awt.Color;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class DashParticlePacket {
    private final UUID id;
    private final float velX;
    private final float velY;
    private final float velZ;
    private final int count;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public DashParticlePacket(UUID id, int count, float velX, float velY, float velZ, int colorR, int colorG, int colorB) {
        this.id = id;
        this.count = count;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public DashParticlePacket(UUID id, int count, float velX, float velY, float velZ, Color clr) {
        this.id = id;
        this.count = count;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.colorR = clr.getRed();
        this.colorG = clr.getGreen();
        this.colorB = clr.getBlue();
    }

    public static DashParticlePacket decode(FriendlyByteBuf buf) {
        return new DashParticlePacket(buf.m_130259_(), buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(DashParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                Player player = level.m_46003_(msg.id);
                if (player != null) {
                    RandomSource rand = level.m_213780_();
                    Color color = new Color(msg.colorR, msg.colorG, msg.colorB);
                    Vec3 pos = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    for (int count = 0; count < msg.count; ++count) {
                        double pitch = (double)(player.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
                        double yaw = (double)(player.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
                        for (int i = 0; i < 10; ++i) {
                            double locDistance = (double)i * 0.5;
                            double X = Math.sin(pitch) * Math.cos(yaw) * locDistance;
                            double Y = Math.cos(pitch) * 2.0;
                            double Z = Math.sin(pitch) * Math.sin(yaw) * locDistance;
                            ArcRandom random = Tmp.rnd;
                            ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.SPHERE).setColorData(ColorParticleData.create((Col)Col.fromColor((Color)color), (Col)Pal.darkestGray).build()).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE).setTransparencyData(GenericParticleData.create((float)random.nextFloat(0.0f, 0.6f), (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.92f, (float)0.0f).build()).setLifetime(15).randomVelocity((double)msg.velX, (double)msg.velY, (double)msg.velZ)).randomOffset((double)0.025f, 0.0, (double)0.025f)).spawn(level, pos.f_82479_ + X + (rand.m_188500_() - 0.5), pos.f_82480_ + Y, pos.f_82481_ + Z + (rand.m_188500_() - 0.5));
                        }
                    }
                } else {
                    Valoria.LOGGER.error("Player with UUID {}, not found", (Object)msg.id);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.writeInt(this.count);
        buf.writeFloat(this.velX);
        buf.writeFloat(this.velY);
        buf.writeFloat(this.velZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

