/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.util.Pal;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class KeypadParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final double targetPosX;
    private final double targetPosY;
    private final double targetPosZ;

    public KeypadParticlePacket(double posX, double posY, double posZ, double targetPosX, double targetPosY, double targetPosZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.targetPosX = targetPosX;
        this.targetPosY = targetPosY;
        this.targetPosZ = targetPosZ;
    }

    public static KeypadParticlePacket decode(FriendlyByteBuf buf) {
        return new KeypadParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(KeypadParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                ArcRandom rand = Tmp.rnd;
                for (int a = 0; a < 3; ++a) {
                    Vec3 position = new Vec3(msg.posX + rand.nextDouble() * 1.25, msg.posY + 0.5 + (rand.nextDouble() - 0.5) * 1.25, msg.posZ + 0.5 + (rand.nextDouble() - 0.5) * 1.25);
                    Vec3 targetPosition = new Vec3(msg.targetPosX + rand.nextDouble() * 1.25, msg.targetPosY + 0.5 + (rand.nextDouble() - 0.5) * 1.25, msg.targetPosZ + 0.5 + (rand.nextDouble() - 0.5) * 1.25);
                    ParticleEffects.transformParticle(pLevel, position, ColorParticleData.create((Col)Pal.moderatePink, (Col)Pal.verySoftPink).build());
                    ParticleEffects.transformParticle(pLevel, targetPosition, ColorParticleData.create((Col)Pal.moderatePink, (Col)Pal.verySoftPink).build());
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.targetPosX);
        buf.writeDouble(this.targetPosY);
        buf.writeDouble(this.targetPosZ);
    }
}

