/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;

public class ManipulatorParticlePacket {
    public BlockPos pos;
    public int given;
    public ColorParticleData data;

    public ManipulatorParticlePacket(BlockPos pos, int given, ColorParticleData data) {
        this.pos = pos;
        this.given = given;
        this.data = data;
    }

    public static ManipulatorParticlePacket decode(FriendlyByteBuf buf) {
        return new ManipulatorParticlePacket(buf.m_130135_(), buf.readInt(), ColorParticleData.create((float)buf.readFloat(), (float)buf.readFloat(), (float)buf.readFloat(), (float)buf.readFloat(), (float)buf.readFloat(), (float)buf.readFloat()).build());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.given);
        buf.writeFloat(this.data.r1);
        buf.writeFloat(this.data.g1);
        buf.writeFloat(this.data.b1);
        buf.writeFloat(this.data.r2);
        buf.writeFloat(this.data.g2);
        buf.writeFloat(this.data.b2);
    }

    public static void handle(ManipulatorParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                for (int a = 0; a < msg.given; ++a) {
                    double angle = (double)a / (double)msg.given * (Math.PI * 2);
                    double x = Math.cos(angle) * 1.0;
                    double z = Math.sin(angle) * 1.0;
                    ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(msg.data).setTransparencyData(GenericParticleData.create((float)0.5f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.35f, (float)0.1f, (float)0.0f).build()).setLifetime(35).spawn(pLevel, (double)((float)msg.pos.m_123341_() + 0.5f) + x, (double)(msg.pos.m_123342_() + 1), (double)((float)msg.pos.m_123343_() + 0.5f) + z);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

