/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.util.Pal;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;

public class MurasamaParticlePacket {
    private final float distance;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public MurasamaParticlePacket(float distance, double posX, double posY, double posZ, int colorR, int colorG, int colorB) {
        this.distance = distance;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static MurasamaParticlePacket decode(FriendlyByteBuf buf) {
        return new MurasamaParticlePacket(buf.readFloat(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(MurasamaParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                RandomSource source = RandomSource.m_216327_();
                double X = (Tmp.rnd.nextDouble() - 0.5) * (double)msg.distance;
                double Y = (Tmp.rnd.nextDouble() - 0.5) * (double)msg.distance;
                double Z = (Tmp.rnd.nextDouble() - 0.5) * (double)msg.distance;
                double dX = -X;
                double dY = -Y;
                double dZ = -Z;
                int count = 1 + Mth.m_216271_((RandomSource)source, (int)0, (int)2);
                for (int ii = 0; ii < count; ++ii) {
                    double yaw = Math.atan2(dZ, dX);
                    double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                    double XX = Math.sin(pitch) * Math.cos(yaw) * (double)((float)(Tmp.rnd.nextDouble() * (double)0.05f)) / (double)(ii + 1);
                    double YY = Math.sin(pitch) * Math.sin(yaw) * (double)((float)(Tmp.rnd.nextDouble() * (double)0.05f)) / (double)(ii + 1);
                    double ZZ = Math.cos(pitch) * (double)((float)(Tmp.rnd.nextDouble() * (double)0.05f)) / (double)(ii + 1);
                    Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                    Vec3 particlePos = new Vec3(msg.posX + X, msg.posY + Y, msg.posZ + Z);
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)color, (Col)Pal.lightViolet).build()).setTransparencyData(GenericParticleData.create((float)0.4f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.1f, (float)0.0f).build()).setLifetime(6).setVelocity(XX, YY, ZZ)).spawn(pLevel, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.distance);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

