/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.google.common.annotations.VisibleForTesting;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.CystSummonParticlePacket;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.types.FleshSpreader;
import com.idark.valoria.registries.entity.living.minions.FleshSentinel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.api.level.BaseSpawner;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;

public class FleshCystBlockEntity
extends BlockEntity
implements TickableBlockEntity,
GameEventListener.Holder<Listener> {
    private final Listener listener;
    private final BaseSpawner spawner = new BaseSpawner(){

        public EntityType<?> getEntityType() {
            return (EntityType)EntityTypeRegistry.FLESH_SENTINEL.get();
        }

        public void onEntityConfiguration(Entity entity, BlockPos pPos) {
            if (entity instanceof FleshSentinel) {
                FleshSentinel fleshSentinel = (FleshSentinel)entity;
                fleshSentinel.setBoundOrigin(pPos);
                fleshSentinel.cystSpawned = true;
            }
        }

        public void onEntitySpawn(ServerLevel pServerLevel, Entity entity, BlockPos pPos) {
            pServerLevel.m_5594_(null, pPos, (SoundEvent)SoundsRegistry.CYST_SUMMON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            PacketHandler.sendToTracking((Level)pServerLevel, pPos, new CystSummonParticlePacket(entity.m_19879_(), pPos));
        }

        public void broadcastEvent(Level p_155767_, BlockPos p_155768_, int p_155769_) {
            p_155767_.m_7696_(p_155768_, (Block)BlockRegistry.fleshCyst.get(), p_155769_, 0);
        }
    };

    public FleshCystBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntitiesRegistry.FLESH_CYST.get(), pPos, pBlockState);
        this.listener = new Listener(pBlockState, (PositionSource)new BlockPositionSource(pPos));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.listener.spreader.load(pTag);
        this.spawner.load(this.f_58857_, this.f_58858_, pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.listener.spreader.save(pTag);
        this.spawner.save(pTag);
    }

    public void tick() {
        if (!this.f_58857_.m_5776_()) {
            this.getSpawner().serverTick((ServerLevel)this.f_58857_, this.m_58899_());
            this.listener.getSpreader().updateCursors((LevelAccessor)this.f_58857_, this.m_58899_(), this.f_58857_.m_213780_(), true);
        } else {
            this.getSpawner().clientTick(this.f_58857_, this.m_58899_());
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public final CompoundTag m_5995_() {
        CompoundTag compoundtag = this.m_187482_();
        this.m_183515_(compoundtag);
        return compoundtag;
    }

    public boolean m_7531_(int pId, int pType) {
        return this.spawner.onEventTriggered(this.f_58857_, pId) || super.m_7531_(pId, pType);
    }

    public boolean m_6326_() {
        return true;
    }

    public BaseSpawner getSpawner() {
        return this.spawner;
    }

    public Listener getListener() {
        return this.listener;
    }

    public class Listener
    implements GameEventListener {
        final FleshSpreader spreader;
        private final BlockState blockState;
        private final PositionSource positionSource;

        public Listener(BlockState pBlockState, PositionSource pPositionSource) {
            this.blockState = pBlockState;
            this.positionSource = pPositionSource;
            this.spreader = FleshSpreader.createLevelSpreader();
        }

        public PositionSource m_142460_() {
            return this.positionSource;
        }

        public int m_142078_() {
            return 8;
        }

        public GameEventListener.DeliveryMode m_247514_() {
            return GameEventListener.DeliveryMode.BY_DISTANCE;
        }

        public boolean m_214068_(ServerLevel pLevel, GameEvent pGameEvent, GameEvent.Context pContext, Vec3 pPos) {
            Entity $$5;
            if (pGameEvent == GameEvent.f_223707_ && ($$5 = pContext.f_223711_()) instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)$$5;
                if (!livingentity.m_217046_()) {
                    int i = livingentity.m_213860_();
                    if (livingentity.m_6149_() && i > 0) {
                        pPos = new Vec3((double)FleshCystBlockEntity.this.m_58899_().m_123341_(), (double)FleshCystBlockEntity.this.m_58899_().m_123342_(), (double)FleshCystBlockEntity.this.m_58899_().m_123343_());
                        this.spreader.addCursors(BlockPos.m_274446_((Position)pPos.m_231075_(Direction.UP, 0.5)), i);
                    }
                    livingentity.m_217045_();
                    this.positionSource.m_142502_((Level)pLevel).ifPresent(p_289513_ -> this.bloom(pLevel, BlockPos.m_274446_((Position)p_289513_), this.blockState, pLevel.m_213780_()));
                }
                return true;
            }
            return false;
        }

        @VisibleForTesting
        public FleshSpreader getSpreader() {
            return this.spreader;
        }

        private void bloom(ServerLevel pLevel, BlockPos pPos, BlockState pState, RandomSource pRandom) {
            pLevel.m_186460_(pPos, pState.m_60734_(), 8);
            pLevel.m_5594_(null, pPos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 0.6f + pRandom.m_188501_() * 0.4f);
        }
    }
}

