/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.client.ui.menus.KegMenu;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.types.KegBlock;
import com.idark.valoria.registries.item.recipe.KegRecipe;
import com.idark.valoria.util.ValoriaUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import pro.komaru.tridot.util.Tmp;

public class KegBlockEntity
extends BlockEntity
implements MenuProvider,
TickableBlockEntity {
    public int progress = 0;
    public int progressMax = 0;
    public int ambientSoundTime;
    public boolean startCraft = false;
    public final ItemStackHandler itemHandler = this.createHandler(1);
    public final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    public final ItemStackHandler itemOutputHandler = this.createHandler(1);
    public final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> this.itemOutputHandler);

    public KegBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public KegBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesRegistry.KEG_BLOCK_ENTITY.get(), pos, state);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                KegBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.valoria.keg");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new KegMenu(pContainerId, this.f_58857_, this.m_58899_(), pPlayer, pPlayerInventory);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("output", (Tag)this.itemOutputHandler.serializeNBT());
        tag.m_128379_("startCraft", this.startCraft);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("progressMax", this.progressMax);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        this.itemOutputHandler.deserializeNBT(tag.m_128469_("output"));
        this.startCraft = tag.m_128471_("startCraft");
        this.progress = tag.m_128451_("progress");
        this.progressMax = tag.m_128451_("progressMax");
    }

    private void resetProgress() {
        this.progress = 0;
        this.startCraft = false;
        KegBlock.setBrewing(this.m_58904_(), this.m_58899_(), this.m_58900_(), false);
    }

    public int getAmbientSoundInterval() {
        return 60;
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    public void playBrewSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), this.getBrewSound(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), this.getAmbientSound(), SoundSource.AMBIENT, 1.0f, Tmp.rnd.nextFloat(1.0f));
        }
    }

    @Nullable
    protected SoundEvent getBrewSound() {
        return (SoundEvent)SoundsRegistry.KEG_BREW.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundsRegistry.KEG_AMBIENT.get();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == null) {
            CombinedInvWrapper item = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.itemOutputHandler});
            return LazyOptional.of(() -> item).cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            Optional<KegRecipe> recipe = this.getCurrentRecipe();
            ItemStack output = this.itemOutputHandler.getStackInSlot(0);
            if (recipe.isPresent() && output.m_41753_() && output.m_41613_() < output.m_41741_() && this.itemOutputHandler.isItemValid(0, output)) {
                this.increaseCraftingProgress();
                this.startCraft = true;
                this.setMaxProgress();
                KegBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
                KegBlock.setBrewing(this.m_58904_(), this.m_58899_(), this.m_58900_(), true);
                if (this.f_58857_.f_46441_.m_188503_(1000) < this.ambientSoundTime++) {
                    this.resetAmbientSoundTime();
                    this.playAmbientSound();
                }
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
                ValoriaUtils.SUpdateTileEntityPacket(this);
            } else {
                this.resetProgress();
            }
        }
    }

    private void craftItem() {
        Optional<KegRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        this.itemHandler.extractItem(0, 1, false);
        this.itemOutputHandler.insertItem(0, result, false);
        this.playBrewSound();
    }

    private Optional<KegRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(3);
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(0));
        return this.f_58857_.m_7465_().m_44015_((RecipeType)KegRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean hasProgressFinished() {
        Optional<KegRecipe> recipe = this.getCurrentRecipe();
        return this.progress >= recipe.get().getTime();
    }

    private void increaseCraftingProgress() {
        Optional<KegRecipe> recipe = this.getCurrentRecipe();
        if (this.progress < recipe.get().getTime()) {
            ++this.progress;
        }
    }

    private void setMaxProgress() {
        Optional<KegRecipe> recipe = this.getCurrentRecipe();
        if (this.progressMax <= 0) {
            this.progressMax = recipe.map(KegRecipe::getTime).orElse(200);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public float getBlockRotate() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            return switch (direction) {
                case Direction.EAST -> 90.0f;
                case Direction.SOUTH -> 360.0f;
                case Direction.WEST -> -90.0f;
                default -> 180.0f;
            };
        }
        return 0.0f;
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ValoriaUtils.SUpdateTileEntityPacket(this);
        }
    }
}

