/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.google.common.collect.Lists;
import com.idark.valoria.client.ui.menus.KilnMenu;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.item.recipe.KilnRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;

public class KilnBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible,
TickableBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_58431_) {
            return switch (p_58431_) {
                case 0 -> KilnBlockEntity.this.litTime;
                case 1 -> KilnBlockEntity.this.litDuration;
                case 2 -> KilnBlockEntity.this.cookingProgress;
                case 3 -> KilnBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    KilnBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    KilnBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    KilnBlockEntity.this.cookingProgress = p_58434_;
                    break;
                }
                case 3: {
                    KilnBlockEntity.this.cookingTotalTime = p_58434_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public KilnBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntitiesRegistry.KILN.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)KilnRecipe.Type.INSTANCE);
        this.recipeType = KilnRecipe.Type.INSTANCE;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"menu.valoria.kiln");
    }

    protected AbstractContainerMenu m_6555_(int pId, Inventory pPlayer) {
        return new KilnMenu(pId, pPlayer, (Container)this, this.dataAccess);
    }

    private static boolean isNeverAFurnaceFuel(Item pItem) {
        return pItem.m_204114_().m_203656_(ItemTags.f_13153_);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.litTime = pTag.m_128451_("BurnTime");
        this.cookingProgress = pTag.m_128451_("CookTime");
        this.cookingTotalTime = pTag.m_128451_("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = pTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("BurnTime", this.litTime);
        pTag.m_128405_("CookTime", this.cookingProgress);
        pTag.m_128405_("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        pTag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public void tick() {
        boolean flag3;
        Level pLevel = this.m_58904_();
        KilnBlockEntity pBlockEntity = this;
        BlockState pState = this.m_58900_();
        BlockPos pPos = this.f_58858_;
        boolean flag = pBlockEntity.isLit();
        boolean flag1 = false;
        if (pBlockEntity.isLit()) {
            --pBlockEntity.litTime;
        }
        ItemStack itemstack = (ItemStack)pBlockEntity.items.get(1);
        boolean flag2 = !((ItemStack)pBlockEntity.items.get(0)).m_41619_();
        boolean bl = flag3 = !itemstack.m_41619_();
        if (pBlockEntity.isLit() || flag3 && flag2) {
            Recipe recipe = flag2 ? (Recipe)pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).orElse(null) : null;
            int i = pBlockEntity.m_6893_();
            if (!pBlockEntity.isLit() && pBlockEntity.canBurn(pLevel.m_9598_(), recipe, pBlockEntity.items, i)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = pBlockEntity.getBurnDuration(itemstack);
                if (pBlockEntity.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        pBlockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        Item item = itemstack.m_41720_();
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            pBlockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (pBlockEntity.isLit() && pBlockEntity.canBurn(pLevel.m_9598_(), recipe, pBlockEntity.items, i)) {
                ++pBlockEntity.cookingProgress;
                if (pBlockEntity.cookingProgress == pBlockEntity.cookingTotalTime) {
                    pBlockEntity.cookingProgress = 0;
                    pBlockEntity.cookingTotalTime = KilnBlockEntity.getTotalCookTime(pLevel, pBlockEntity);
                    if (pBlockEntity.burn(pLevel.m_9598_(), recipe, pBlockEntity.items, i)) {
                        pBlockEntity.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
        } else if (!pBlockEntity.isLit() && pBlockEntity.cookingProgress > 0) {
            pBlockEntity.cookingProgress = Mth.m_14045_((int)(pBlockEntity.cookingProgress - 2), (int)0, (int)pBlockEntity.cookingTotalTime);
        }
        if (flag != pBlockEntity.isLit()) {
            flag1 = true;
            pState = (BlockState)pState.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(pBlockEntity.isLit()));
            pLevel.m_7731_(pPos, pState, 3);
        }
        if (flag1) {
            KilnBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private boolean canBurn(RegistryAccess pRegistryAccess, @Nullable Recipe<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize) {
        if (!((ItemStack)pInventory.get(0)).m_41619_() && pRecipe != null) {
            ItemStack itemstack = pRecipe.m_5874_((Container)this, pRegistryAccess);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)pInventory.get(2);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= pMaxStackSize && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean burn(RegistryAccess pRegistryAccess, @Nullable Recipe<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize) {
        if (pRecipe != null && this.canBurn(pRegistryAccess, pRecipe, pInventory, pMaxStackSize)) {
            ItemStack itemstack = (ItemStack)pInventory.get(0);
            ItemStack itemstack1 = pRecipe.m_5874_((Container)this, pRegistryAccess);
            ItemStack itemstack2 = (ItemStack)pInventory.get(2);
            if (itemstack2.m_41619_()) {
                pInventory.set(2, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (itemstack.m_150930_(Blocks.f_50057_.m_5456_()) && !((ItemStack)pInventory.get(1)).m_41619_() && ((ItemStack)pInventory.get(1)).m_150930_(Items.f_42446_)) {
                pInventory.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.m_41619_()) {
            return 0;
        }
        Item item = pFuel.m_41720_();
        return ForgeHooks.getBurnTime((ItemStack)pFuel, this.recipeType);
    }

    private static int getTotalCookTime(Level pLevel, KilnBlockEntity pBlockEntity) {
        return pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    public static boolean isFuel(ItemStack pStack) {
        return ForgeHooks.getBurnTime((ItemStack)pStack, null) > 0;
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pDirection == Direction.DOWN && pIndex == 1) {
            return pStack.m_150930_(Items.f_42447_) || pStack.m_150930_(Items.f_42446_);
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pIndex, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pIndex == 0 && !flag) {
            this.cookingTotalTime = KilnBlockEntity.getTotalCookTime(this.f_58857_, this);
            this.cookingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 2) {
            return false;
        }
        if (pIndex != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return ForgeHooks.getBurnTime((ItemStack)pStack, this.recipeType) > 0 || pStack.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player pPlayer, List<ItemStack> pItems) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(pPlayer.m_284548_(), pPlayer.m_20182_());
        pPlayer.m_7281_(list);
        for (Recipe<?> recipe : list) {
            if (recipe == null) continue;
            pPlayer.m_280300_(recipe, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                KilnBlockEntity.createExperience(pLevel, pPopVec, entry.getIntValue(), ((AbstractCookingRecipe)p_155023_).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        int i = Mth.m_14143_((float)((float)pRecipeIndex * pExperience));
        float f = Mth.m_14187_((float)((float)pRecipeIndex * pExperience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)pPopVec, (int)i);
    }

    public void m_5809_(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.m_36491_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

