/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.ItemsRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractGoblin
extends PathfinderMob
implements NeutralMob,
Enemy {
    public final SimpleContainer inventory = new SimpleContainer(8);
    public static final Predicate<ItemEntity> ALLOWED_ITEMS = p_289438_ -> !p_289438_.m_32063_() && p_289438_.m_6084_() || p_289438_.m_32055_().m_41614_() || p_289438_.m_32055_() == Items.f_42417_.m_7968_() || p_289438_.m_32055_() == Items.f_41912_.m_7968_() || p_289438_.m_32055_() == Items.f_42587_.m_7968_() || p_289438_.m_32055_() == ((Item)ItemsRegistry.samuraiKunai.get()).m_7968_() || p_289438_.m_32055_() == ((Item)ItemsRegistry.samuraiPoisonedKunai.get()).m_7968_() || p_289438_.m_32055_().m_41720_() instanceof SwordItem;
    public static List<Item> goblinCanSpawnWith = new ArrayList<Item>();
    @Nullable
    public UUID persistentAngerTarget;
    public int ticksSinceEaten;
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(AbstractGoblin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    public static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(AbstractGoblin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractGoblin(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public static void spawnable(Item ... T) {
        Collections.addAll(goblinCanSpawnWith, T);
    }

    @VisibleForDebug
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.inventory.m_19195_().forEach(arg_0 -> ((AbstractGoblin)this).m_19983_(arg_0));
    }

    public boolean m_8028_() {
        return false;
    }

    public boolean canEat(ItemStack pStack) {
        return pStack.m_41720_().m_41472_() && this.m_5448_() == null && this.m_20096_() && !this.m_5803_();
    }

    public boolean m_7243_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() || item == ItemsRegistry.samuraiKunai.get() || item == ItemsRegistry.samuraiPoisonedKunai.get() || item == Items.f_42417_ || item == Items.f_41912_ || item == Items.f_42587_ || item instanceof SwordItem && this.getInventory().m_19183_(pStack);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((double)this.f_21364_ * 2.5);
        }
        return super.m_213860_();
    }

    public void m_8107_() {
        Level level;
        boolean flag;
        boolean bl = flag = this.m_21223_() < 12.0f;
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack foodStack = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!foodStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, foodStack);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                    this.m_5634_(1.25f);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (flag) {
                this.m_21561_(false);
                this.m_21661_();
                this.m_21666_(serverLevel, true);
            } else {
                this.m_21666_(serverLevel, true);
            }
        }
        super.m_8107_();
    }

    public final boolean isLowHP() {
        return this.m_21223_() < 12.0f;
    }

    public void m_7822_(byte pId) {
        if (pId == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_7252_(ItemStack pStack) {
        return super.m_7252_(pStack);
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public float m_6134_() {
        return this.m_6162_() ? 1.0f : 1.45f;
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public void m_6863_(boolean Baby) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)Baby);
    }
}

