/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.entity.living.Troll;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class ShadewoodSpider
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(ShadewoodSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public ShadewoodSpider(EntityType<? extends ShadewoodSpider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 3;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public double m_6048_() {
        return this.m_20206_() * 0.5f;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    public static boolean m_219013_(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        if (pPotioneffect.m_19544_() == MobEffects.f_19614_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, pPotioneffect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(pPotioneffect);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Troll mob;
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        RandomSource randomsource = pLevel.m_213780_();
        if (randomsource.m_188503_(100) == 0 && (mob = (Troll)((EntityType)EntityTypeRegistry.CORRUPTED_TROLL.get()).m_20615_(this.m_9236_())) != null) {
            mob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            mob.m_6518_(pLevel, pDifficulty, pReason, null, null);
            mob.m_20329_((Entity)this);
        }
        if (pSpawnData == null) {
            pSpawnData = new Spider.SpiderEffectsGroupData();
            if (pLevel.m_46791_() == Difficulty.HARD && randomsource.m_188501_() < 0.1f * pDifficulty.m_19057_()) {
                ((Spider.SpiderEffectsGroupData)pSpawnData).m_219118_(randomsource);
            }
        }
        if (pSpawnData instanceof Spider.SpiderEffectsGroupData) {
            Spider.SpiderEffectsGroupData spider$spidereffectsgroupdata = (Spider.SpiderEffectsGroupData)pSpawnData;
            MobEffect mobeffect = spider$spidereffectsgroupdata.f_33827_;
            if (mobeffect != null) {
                this.m_7292_(new MobEffectInstance(mobeffect, -1));
            }
        }
        return pSpawnData;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.65f;
    }
}

