/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import com.idark.valoria.registries.entity.living.elemental.Devil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeHooks;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;

public class AbstractDevil
extends MultiAttackMob
implements Enemy {
    public AbstractDevil(EntityType<? extends MultiAttackMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 5;
        this.m_21573_().m_7008_(false);
        this.applyOpenDoorsAbility();
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.m_45517_(LightLayer.SKY, pPos) > pRandom.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = pLevel.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && pLevel.m_45517_(LightLayer.BLOCK, pPos) > i) {
            return false;
        }
        int j = pLevel.m_6018_().m_46470_() ? pLevel.m_46849_(pPos, 10) : pLevel.m_46803_(pPos);
        return j <= dimensiontype.m_223569_().m_214085_(pRandom);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Devil> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && AbstractDevil.isDarkEnoughToSpawn(pLevel, pPos, pRandom) && AbstractDevil.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom) && (!pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50451_) || !pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50692_));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    protected boolean m_8028_() {
        return true;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12042_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12041_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12039_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12038_;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_12040_, SoundEvents.f_12037_);
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return -pLevel.m_220419_(pPos);
    }

    public boolean m_6149_() {
        return true;
    }

    protected boolean m_6125_() {
        return true;
    }

    public ItemStack m_6298_(ItemStack pShootable) {
        if (pShootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)(itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack));
        }
        return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)ItemStack.f_41583_);
    }

    private void applyOpenDoorsAbility() {
        if (GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
    }

    public boolean isAdult() {
        return !this.m_6162_();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new MultiAttackMob.PrepareGoal((MultiAttackMob)this));
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ /= 2;
        }
        return super.m_213860_();
    }
}

