/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.entity.projectile.WaterBubble;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.util.Tmp;

public class KingCrabEntity
extends MultiAttackMob
implements Enemy {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState splashAttackAnimationState = new AnimationState();
    public final AnimationState hookAttackAnimationState = new AnimationState();
    public final AnimationState hideAnimationState = new AnimationState();
    public final AnimationState revealAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> HITS_NEEDED = SynchedEntityData.m_135353_(KingCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HIDE_ANIMATION_STARTED = SynchedEntityData.m_135353_(KingCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int idleAnimationTimeout = 0;
    public int shieldHurtTime = 0;
    public int hookAttackAnimationTime = 0;
    public int splashAttackAnimationTime = 0;
    private int animatedDeathTime;
    private boolean initAnim;

    public KingCrabEntity(EntityType<? extends KingCrabEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.f_21364_ = 25;
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || pEntity instanceof KingCrabEntity;
    }

    public void setHits(int hitsNeeded) {
        this.f_19804_.m_135381_(HITS_NEEDED, (Object)hitsNeeded);
    }

    public void setHideAnimationState(boolean bool) {
        this.f_19804_.m_135381_(HIDE_ANIMATION_STARTED, (Object)bool);
    }

    public boolean getHideAnimationState() {
        return (Boolean)this.f_19804_.m_135370_(HIDE_ANIMATION_STARTED);
    }

    public int getHits() {
        return (Integer)this.f_19804_.m_135370_(HITS_NEEDED);
    }

    public void m_8119_() {
        super.m_8119_();
        --this.shieldHurtTime;
        if (this.getHits() > 0 && this.f_19797_ % 20 == 0) {
            this.setHits(this.getHits() - 1);
            this.m_5634_(0.5f);
        }
        if (this.hookAttackAnimationTime > 0) {
            --this.hookAttackAnimationTime;
            if (this.hookAttackAnimationTime == this.attackDelay() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.isWithinAttackRange(this.m_5448_(), 3.0)) {
                KingCrabEntity entity = this;
                LivingEntity target = this.m_5448_();
                entity.m_7327_((Entity)target);
                Vec3 direction = entity.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                double strength = Mth.m_14008_((double)((double)entity.m_20270_((Entity)target) * 0.2), (double)0.25, (double)1.5);
                target.m_20256_(direction.m_82490_(strength));
                target.f_19864_ = true;
            }
        }
        if (this.splashAttackAnimationTime > 0) {
            LivingEntity livingentity;
            --this.splashAttackAnimationTime;
            if (this.splashAttackAnimationTime == this.attackDelay() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.isWithinAttackRange(this.m_5448_(), 5.0) && (livingentity = this.m_5448_()) != null) {
                double d0 = Math.min(livingentity.m_20186_(), this.m_20186_());
                double d1 = Math.max(livingentity.m_20186_(), this.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
                if (this.m_20280_((Entity)livingentity) > 6.0) {
                    for (int i = 0; i < 6; ++i) {
                        float f1 = f + (float)i * (float)Math.PI * 0.4f;
                        this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f1) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f1) * 2.5, d0, d1, f1, 0);
                    }
                    for (int k = 0; k < 12; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 4.5, d0, d1, f2, 3);
                    }
                }
            }
        }
        if (this.getHits() == 0 && this.getHideAnimationState() && this.f_19797_ % 20 == 0) {
            this.hideAnimationState.m_216973_();
            this.revealAnimationState.m_216977_(this.f_19797_);
            this.setHideAnimationState(false);
        }
        if (this.m_9236_().f_46443_ && !this.initAnim && this.f_19797_ > 10) {
            if (this.getHits() > 0) {
                this.hideAnimationState.m_216977_(this.f_19797_);
            }
            this.initAnim = true;
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void createSpellEntity(double pX, double pZ, double pMinY, double pMaxY, float pYRot, int pWarmupDelay) {
        BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pMaxY, (double)pZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new WaterBubble(this.m_9236_(), pX, (double)blockpos.m_123342_() + d0, pZ, pYRot, pWarmupDelay, 4.0f, (LivingEntity)this));
        }
    }

    public double getAttackRangeSqr(LivingEntity pEntity, double range) {
        return (double)this.m_20205_() * range * (double)this.m_20205_() * range + (double)pEntity.m_20205_();
    }

    public double getPerceivedTargetDistanceSquareForAttack(LivingEntity pEntity) {
        return this.m_20238_(pEntity.m_20182_());
    }

    public boolean isWithinAttackRange(LivingEntity pEntity, double range) {
        double d0 = this.getPerceivedTargetDistanceSquareForAttack(pEntity);
        return d0 <= this.getAttackRangeSqr(pEntity, range);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            if (this.getHits() == 0) {
                this.idleAnimationTimeout = 50;
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 3) {
            this.hideAnimationState.m_216973_();
            this.deathAnimationState.m_216977_(this.f_19797_);
            SoundEvent soundevent = this.m_5592_();
            if (soundevent != null) {
                this.m_5496_(soundevent, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
            this.m_21153_(0.0f);
            this.m_6667_(this.m_269291_().m_269264_());
        } else if (pId == 60) {
            this.setHideAnimationState(true);
            this.hideAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 61) {
            this.setHideAnimationState(false);
            this.hideAnimationState.m_216973_();
            this.revealAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 62) {
            this.shieldHurtTime = 10;
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        } else if (pId == 65) {
            this.splashAttackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 64) {
            this.hookAttackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_6153_() {
        ++this.animatedDeathTime;
        if (this.animatedDeathTime >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6673_(DamageSource pSource) {
        if (this.getHits() > 0) {
            return !pSource.m_269533_(DamageTypeTags.f_268738_);
        }
        return super.m_6673_(pSource);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.getHits() > 0) {
            this.setHits(this.getHits() - 1);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_276434_, SoundSource.HOSTILE, 2.0f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)62);
            if (pSource.m_7640_() != null) {
                pSource.m_7640_().m_6469_(this.m_9236_().m_269111_().m_269374_((Entity)this), pAmount * 0.15f);
            }
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new KingCrabSplashAttack());
        this.f_21345_.m_25352_(0, (Goal)new HideInShell(25));
        this.f_21345_.m_25352_(0, (Goal)new KingCrabHookAttack());
        this.f_21345_.m_25352_(4, (Goal)new KingCrabAttack(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, Objects::nonNull));
        this.f_21346_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 16.0f, 1.0, 2.0));
    }

    public double m_6048_() {
        return this.m_20206_() * 0.75f;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("HitsNeeded", this.getHits());
        pCompound.m_128379_("AnimationStarted", this.getHideAnimationState());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setHits(pCompound.m_128451_("HitsNeeded"));
        this.setHideAnimationState(pCompound.m_128471_("AnimationStarted"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HITS_NEEDED, (Object)0);
        this.f_19804_.m_135372_(HIDE_ANIMATION_STARTED, (Object)false);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends KingCrabEntity> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && KingCrabEntity.isBrightEnoughToSpawn((BlockAndTintGetter)pLevel, pPos);
    }

    public static boolean isBrightEnoughToSpawn(BlockAndTintGetter pLevel, BlockPos pPos) {
        return pLevel.m_45524_(pPos, 0) > 8;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.65f;
    }

    public boolean m_6067_() {
        return this.m_6069_();
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getHits() > 0;
    }

    public boolean m_21515_() {
        return super.m_21515_() || this.getHits() > 0;
    }

    public class KingCrabSplashAttack
    extends MultiAttackMob.AttackGoal {
        public KingCrabSplashAttack() {
            super((MultiAttackMob)KingCrabEntity.this);
        }

        public void onPrepare() {
            KingCrabEntity.this.m_9236_().m_7605_((Entity)KingCrabEntity.this, (byte)65);
            KingCrabEntity.this.splashAttackAnimationTime = 30;
        }

        public boolean m_8036_() {
            return super.m_8036_() && KingCrabEntity.this.m_20280_((Entity)KingCrabEntity.this.m_5448_()) > 6.0 && KingCrabEntity.this.isWithinAttackRange(KingCrabEntity.this.m_5448_(), 5.0);
        }

        protected void performAttack() {
        }

        public int getPreparingTime() {
            return 40;
        }

        public int getAttackInterval() {
            return 320;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.RADIAL;
        }
    }

    public class HideInShell
    extends MultiAttackMob.AttackGoal {
        public int hits;

        public HideInShell(int hits) {
            super((MultiAttackMob)KingCrabEntity.this);
            this.hits = hits;
        }

        public void onPrepare() {
        }

        public boolean m_8036_() {
            return super.m_8036_() && KingCrabEntity.this.m_21223_() < KingCrabEntity.this.m_21233_() * 0.3f && Tmp.rnd.chance(0.25f);
        }

        public void m_8056_() {
            KingCrabEntity.this.setHits(this.hits);
            KingCrabEntity.this.setHideAnimationState(true);
            super.m_8056_();
        }

        protected void performAttack() {
            KingCrabEntity.this.m_9236_().m_7605_((Entity)KingCrabEntity.this, (byte)60);
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 600;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.BLOCK;
        }
    }

    public class KingCrabHookAttack
    extends MultiAttackMob.AttackGoal {
        public KingCrabHookAttack() {
            super((MultiAttackMob)KingCrabEntity.this);
        }

        public void onPrepare() {
            KingCrabEntity.this.hookAttackAnimationTime = 20;
            KingCrabEntity.this.m_9236_().m_7605_((Entity)KingCrabEntity.this, (byte)64);
        }

        protected void performAttack() {
        }

        public boolean m_8036_() {
            return super.m_8036_() && KingCrabEntity.this.m_20270_((Entity)KingCrabEntity.this.m_5448_()) > 2.0f && KingCrabEntity.this.isWithinAttackRange(KingCrabEntity.this.m_5448_(), 3.0);
        }

        public int getPreparingTime() {
            return 30;
        }

        public int getAttackInterval() {
            return 250;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.THROW;
        }
    }

    public class KingCrabAttack
    extends MultiAttackMob.TridotMeleeAttackGoal {
        public KingCrabAttack(MultiAttackMob mob, double speedModifier) {
            super((MultiAttackMob)KingCrabEntity.this, mob, speedModifier);
        }

        public int attackAnimationTick() {
            return 15;
        }

        public void beforeAttack() {
            super.beforeAttack();
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 20;
        }

        public SoundEvent getPrepareSound() {
            return SoundEvents.f_12057_;
        }

        public SoundEvent getAttackSound() {
            return SoundEvents.f_12316_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MELEE;
        }
    }
}

