/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.interfaces.TexturedArrow;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;
import pro.komaru.tridot.util.Col;

public class PhantomArrow
extends AbstractTridotArrow
implements TexturedArrow {
    private boolean child;
    public boolean burst;
    public float spread = 6.0f;

    public PhantomArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PhantomArrow(Level pLevel, LivingEntity pShooter, ItemStack thrown) {
        super((EntityType)EntityTypeRegistry.PHANTOM_ARROW.get(), pLevel, pShooter, thrown, 6.0);
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        Vec3 pos = pResult.m_82450_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.child) {
                if (!this.burst) {
                    return;
                }
                for (int i = 0; i < 12; ++i) {
                    PhantomArrow arrow = (PhantomArrow)((EntityType)EntityTypeRegistry.PHANTOM_ARROW.get()).m_20615_((Level)serverLevel);
                    if (arrow == null) continue;
                    double offsetX = this.f_19796_.m_188500_() * (double)this.spread * 2.0 - (double)this.spread;
                    double offsetZ = this.f_19796_.m_188500_() * (double)this.spread * 2.0 - (double)this.spread;
                    double x = pos.f_82479_ + offsetX;
                    double z = pos.f_82481_ + offsetZ;
                    double y = pos.f_82480_ + 16.0 + this.f_19796_.m_188500_() * 8.0;
                    arrow.m_7678_(x, y, z, 0.0f, 0.0f);
                    arrow.m_20334_(0.0, -1.5 - this.f_19796_.m_188500_(), 0.0);
                    arrow.child = true;
                    if (this.m_19749_() != null) {
                        arrow.m_5602_(this.m_19749_());
                    }
                    serverLevel.m_7967_((Entity)arrow);
                    serverLevel.m_6263_(null, x, y, z, SoundEvents.f_11687_, SoundSource.PLAYERS, 0.5f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
                }
            } else {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
                this.m_6089_();
            }
        }
        this.burst = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (!this.f_36703_) {
            Vec3 delta = this.m_20184_().m_82541_();
            Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 1.5E-4, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 1.5E-4);
            Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
            Consumer<GenericParticle> target = p -> {
                Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
                Vec3 vector = arrowPos.m_82546_(cachePos[0]);
                if (lenBetweenArrowAndParticle > 0.0f) {
                    cachePos[0] = cachePos[0].m_82549_(vector);
                    p.setPosition(cachePos[0]);
                }
            };
            ParticleEffects.smoothTrail(this.m_9236_(), target, pos, ColorParticleData.create((Col)Col.fromHex((String)"193ce1"), (Col)Col.fromHex((String)"201aeb")).build());
            ParticleEffects.trailMotionSparks(this.m_9236_(), pos, ColorParticleData.create((Col)Col.fromHex((String)"193ce1"), (Col)Col.fromHex((String)"201aeb")).build());
        }
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("valoria", "textures/entity/projectile/arrow/phantom_arrow.png");
    }
}

