/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.TexturedArrow;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.TrailParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class SoulArrow
extends AbstractTridotArrow
implements TexturedArrow {
    public SoulArrow(EntityType<? extends AbstractTridotArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SoulArrow(Level pLevel, ItemStack thrown) {
        super((EntityType)EntityTypeRegistry.SOUL_ARROW.get(), pLevel);
        this.arrowItem = ItemStack.f_41583_;
        this.arrowItem = new ItemStack((ItemLike)thrown.m_41720_());
        this.f_36698_ = 1.0;
    }

    public SoulArrow(Level pLevel, LivingEntity pShooter, ItemStack thrown) {
        super((EntityType)EntityTypeRegistry.SOUL_ARROW.get(), pLevel, pShooter, thrown, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            return;
        }
        AABB box = this.m_20191_().m_82400_(8.0);
        Utils.Physics.homingTo((double)1.0, (Entity)this, (Level)this.m_9236_(), (Entity)this.m_19749_(), (AABB)box);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (!this.f_36703_) {
            Vec3 vec3 = Vec3.f_82478_;
            Vec3 delta = this.m_20184_().m_82541_();
            Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 0.05415, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 0.05415);
            Consumer<GenericParticle> pT = p -> {
                double dX = vec3.m_7096_();
                double dY = vec3.m_7098_();
                double dZ = vec3.m_7094_();
                double yaw = Math.atan2(dZ, dX);
                double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                float speed = 0.1f + (float)p.getAge() * 0.001f;
                double x = Math.sin(pitch) * Math.cos(yaw) * (double)speed;
                double y = Math.cos(pitch) * (double)speed;
                double z = Math.sin(pitch) * Math.sin(yaw) * (double)speed;
                p.setSpeed(p.getSpeed().m_82520_(-x, -y, -z));
            };
            ((ParticleBuilder)((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(ColorParticleData.create((Col)Col.white, (Col)Col.fromHex((String)"19419b")).build()).setTransparencyData(GenericParticleData.create((float)0.5f, (float)0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.5f).setEasing(Interp.sineIn).build()).addTickActor(pT).setLifetime(10).randomVelocity(0.25, 0.0, 0.25)).randomOffset((double)0.15f)).setVelocity(vec3.f_82479_, 0.0, vec3.f_82481_)).setFriction(0.8f).repeat(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 10);
            Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
            Consumer<GenericParticle> target = p -> {
                Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
                Vec3 vector = arrowPos.m_82546_(cachePos[0]);
                if (lenBetweenArrowAndParticle > 0.0f) {
                    cachePos[0] = cachePos[0].m_82549_(vector);
                    p.setPosition(cachePos[0]);
                }
            };
            ParticleEffects.smoothTrail(this.m_9236_(), target, pos, ColorParticleData.create((Col)Col.fromHex((String)"19419b"), (Col)Col.fromHex((String)"0000af")).build());
        }
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("valoria", "textures/entity/projectile/arrow/soul_arrow.png");
    }
}

