/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class JewelryRecipe
implements Recipe<Container> {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int time;

    public JewelryRecipe(ResourceLocation id, ItemStack output, int time, Ingredient ... inputItems) {
        this.id = id;
        this.output = output;
        this.time = time;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputItems);
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        boolean craft = true;
        for (int i = 0; i < 2; ++i) {
            if (((Ingredient)this.inputs.get(i)).test(pContainer.m_8020_(i))) continue;
            craft = false;
        }
        return craft;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public int getTime() {
        return this.time;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<JewelryRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("valoria", "jewelry");

        public JewelryRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            int time = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"time");
            JsonArray pIngredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : pIngredients) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new JewelryRecipe(pRecipeId, output, time, inputs.toArray(new Ingredient[0]));
        }

        @Nullable
        public JewelryRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient[] inputs = new Ingredient[pBuffer.readInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            }
            ItemStack output = pBuffer.m_130267_();
            int time = pBuffer.readInt();
            return new JewelryRecipe(pRecipeId, output, time, inputs);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, JewelryRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient input : pRecipe.m_7527_()) {
                input.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), false);
            pBuffer.writeInt(pRecipe.getTime());
        }
    }

    public static class Type
    implements RecipeType<JewelryRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "jewelry";
    }
}

