/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.BeastAttackParticlePacket;
import com.idark.valoria.registries.entity.projectile.Devourer;
import com.idark.valoria.registries.item.types.ScytheItem;
import com.idark.valoria.registries.item.types.builders.AbstractScytheBuilder;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.struct.data.Seq;

public class BeastScytheItem
extends ScytheItem {
    public BeastScytheItem(Builder builderIn) {
        super(builderIn);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        pAttacker.m_9236_().m_5594_(null, pTarget.m_20097_(), SoundEvents.f_12228_, SoundSource.PLAYERS, 0.25f, 0.34f);
        return true;
    }

    protected void performSpellCasting(Level level, Player player) {
        float yaw;
        double spellZ;
        double spellX;
        float angle;
        double d0 = Math.min((double)player.m_146908_(), player.m_20186_());
        double d1 = Math.max((double)player.m_146908_(), player.m_20186_()) + 1.0;
        float playerYaw = player.m_146908_() * ((float)Math.PI / 180);
        for (int i = 0; i < 5; ++i) {
            angle = playerYaw + (float)i * (float)Math.PI / 2.0f;
            spellX = player.m_20185_() + Math.cos(angle) * 1.5;
            spellZ = player.m_20189_() + Math.sin(angle) * 1.5;
            yaw = (float)(Math.atan2(player.m_20189_() - spellZ, player.m_20185_() - spellX) * 565.4866776461628);
            this.createSpellEntity(level, player.m_20185_() + Math.cos(angle) * 1.5, player.m_20189_() + Math.sin(angle) * 1.5, d0, d1, yaw, 0);
        }
        for (int k = 0; k < 8; ++k) {
            angle = playerYaw + (float)k * (float)Math.PI / 4.0f + 1.2566371f;
            spellX = player.m_20185_() + Math.cos(angle) * 3.0;
            spellZ = player.m_20189_() + Math.sin(angle) * 3.0;
            yaw = (float)(Math.atan2(player.m_20189_() - spellZ, player.m_20185_() - spellX) * 282.7433388230814);
            this.createSpellEntity(level, player.m_20185_() + Math.cos(angle) * 3.0, player.m_20189_() + Math.sin(angle) * 3.0, d0, d1, yaw, 6);
        }
    }

    private void createSpellEntity(Level level, double pX, double pZ, double pMinY, double pMaxY, float pYRot, int pWarmupDelay) {
        BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pMaxY, (double)pZ);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = level.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP)) continue;
            if (!level.m_46859_(blockpos) && !(voxelshape = (blockstate1 = level.m_8055_(blockpos)).m_60812_((BlockGetter)level, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
        if (flag && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            PacketHandler.sendToTracking((Level)server, blockpos, new BeastAttackParticlePacket(pX, (double)blockpos.m_123342_() + d0, pZ, Col.fromHex((String)"66b4a3").toJava()));
            server.m_7967_((Entity)new Devourer((Level)server, pX, (double)blockpos.m_123342_() + d0, pZ, pYRot, pWarmupDelay, null));
        }
    }

    @Override
    public void performAttack(Level level, ItemStack stack, Player player) {
        float damage = (float)player.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44821_((LivingEntity)player);
        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        ArrayList markEntities = new ArrayList();
        ValoriaUtils.radiusHit(level, stack, player, null, hitEntities, pos, 0.0f, player.m_20155_().f_82471_, 3.0f);
        Utils.Particles.mark((Level)level, (Player)player, markEntities, (ParticleOptions)((ParticleOptions)ParticleRegistry.CHOMP.get()), (Vector3d)pos, (float)0.0f, (float)player.m_20155_().f_82471_, (float)3.0f);
        this.applyCooldown(player, hitEntities.isEmpty() ? this.builder.minCooldownTime : this.builder.cooldownTime);
        this.performSpellCasting(level, player);
        for (LivingEntity entity : hitEntities) {
            if (!player.m_6779_(entity)) continue;
            entity.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
            this.performEffects(entity, player);
            Utils.Entities.applyWithChance((LivingEntity)entity, this.builder.effects, (float)this.builder.chance, (ArcRandom)this.arcRandom);
            if (!player.m_7500_()) {
                stack.m_41622_(hitEntities.size(), (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (entity instanceof Player && ((Player)entity).m_7500_()) continue;
            entity.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
            entity.m_20334_((player.m_20185_() - entity.m_20185_()) * 0.06, 0.1, (player.m_20189_() - entity.m_20189_()) * 0.06);
        }
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11865_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    @Override
    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.beast").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/devourer.png")), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
    }

    public static class Builder
    extends AbstractScytheBuilder<BeastScytheItem> {
        public Builder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
            super(attackDamageIn, attackSpeedIn, itemProperties);
        }

        @Override
        public BeastScytheItem build() {
            return new BeastScytheItem(this);
        }
    }
}

