/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.idark.valoria.Valoria;
import com.idark.valoria.api.events.CodexEvent;
import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.api.unlockable.types.Unlockable;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class CodexPageItem
extends Item {
    public Supplier<Unlockable> unlockable;
    public String lang;
    public boolean rand;

    public CodexPageItem(Item.Properties props, Supplier<Unlockable> pUnlockable, String pPageName) {
        super(props);
        this.unlockable = pUnlockable;
        this.lang = pPageName;
    }

    public CodexPageItem(Item.Properties props) {
        super(props);
        this.rand = true;
    }

    public CodexPageItem(Item.Properties props, Supplier<Unlockable> pUnlockable) {
        super(props);
        this.unlockable = pUnlockable;
    }

    public String m_5524_() {
        return Util.m_137492_((String)"item", (ResourceLocation)Valoria.loc("page"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (world.f_46443_ || !(player instanceof ServerPlayer)) return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.rand) {
            Unlockable rU = UnlockUtils.getRandom(player);
            if (rU == null || UnlockUtils.isUnlocked(player, rU) || CodexPageItem.onUnlock(rU)) return CodexPageItem.interactionFail(world, player, stack);
            stack.m_41774_(1);
            UnlockUtils.add(serverPlayer, rU);
            String path = rU.getId().replace(":", ".");
            serverPlayer.m_5661_((Component)Component.m_237115_((String)("codex." + path + ".name")).m_130940_(ChatFormatting.GRAY), true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        } else {
            Unlockable unlockable = this.unlockable.get();
            if (UnlockUtils.isUnlocked(player, unlockable) || CodexPageItem.onUnlock(unlockable)) return CodexPageItem.interactionFail(world, player, stack);
            stack.m_41774_(1);
            UnlockUtils.add(serverPlayer, unlockable);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
    }

    @NotNull
    private static InteractionResultHolder<ItemStack> interactionFail(Level world, Player player, ItemStack stack) {
        world.m_5594_(null, player.m_20097_(), SoundEvents.f_12321_, SoundSource.AMBIENT, 0.7f, 0.2f);
        player.m_5661_((Component)Component.m_237115_((String)"codex.valoria.obtained").m_130940_(ChatFormatting.GRAY), true);
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private static boolean onUnlock(Unlockable unlockable) {
        return MinecraftForge.EVENT_BUS.post((Event)new CodexEvent.OnPageUnlocked(unlockable));
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (this.lang != null && !this.lang.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.page").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)this.lang).m_130940_(ChatFormatting.BLUE)));
        }
        if (this.rand) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.page").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"tooltip.valoria.random_page").m_130940_(ChatFormatting.BLUE)));
        }
    }
}

