/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.entity.ai.movements.FlyingAroundMovement;
import com.idark.valoria.registries.entity.living.minions.CrystalEntity;
import com.idark.valoria.registries.item.types.SummonBook;
import com.idark.valoria.util.Styles;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CrystalSummonBook
extends SummonBook {
    private static final ResourceKey<EntityType<?>> DEFAULT_VARIANT = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (ResourceLocation)new ResourceLocation("valoria", "crystal"));

    public CrystalSummonBook(int lifetime, int count, Item.Properties pProperties) {
        super(lifetime, count, pProperties);
    }

    public ItemStack m_7968_() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        CompoundTag tag = itemStack.m_41698_("EntityTag");
        tag.m_128359_("id", DEFAULT_VARIANT.m_135782_().toString());
        return itemStack;
    }

    @Override
    protected EntityType<?> getDefaultType(ItemStack stack) {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(DEFAULT_VARIANT.m_135782_());
    }

    private void spawn(ServerLevel level, BlockPos blockpos, Player player, float angle) {
        CrystalEntity crystal = (CrystalEntity)((EntityType)EntityTypeRegistry.CRYSTAL.get()).m_20615_(player.m_9236_());
        if (crystal != null && level.m_46859_(blockpos)) {
            crystal.m_20035_(blockpos, 0.0f, 0.0f);
            crystal.m_6518_((ServerLevelAccessor)level, player.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
            crystal.setOwner((LivingEntity)player);
            crystal.movement = new FlyingAroundMovement((Mob)crystal, (Entity)player);
            crystal.movement.setRadius(3.0f);
            crystal.movement.setAngle(angle);
            crystal.setBoundOrigin(blockpos);
            crystal.setLimitedLife(285);
            level.m_7967_((Entity)crystal);
        }
    }

    @Override
    public void applyCooldown(Player playerIn) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof SummonBook)) continue;
            playerIn.m_36335_().m_41524_(item, 325);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player = (Player)entityLiving;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                float initialAngle = (float)(1.5707963267948966 * (double)i);
                this.spawn(serverLevel, player.m_20183_().m_7494_(), player, initialAngle);
            }
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, plr -> plr.m_21166_(EquipmentSlot.MAINHAND));
            }
            level.m_247517_(null, player.m_20183_(), this.getUseSound(), SoundSource.PLAYERS);
            this.applyCooldown(player);
        }
        return stack;
    }

    @Override
    public Component getHighlightTip(ItemStack stack, Component displayName) {
        return displayName.m_6881_().m_7220_((Component)Component.m_237113_((String)(" [" + this.getDefaultType(stack).m_20676_().getString() + "]")).m_130948_((Style)Styles.arcaneGold));
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.summons", (Object[])new Object[]{this.getDefaultType(stack).m_20676_()}).m_130940_(ChatFormatting.GRAY));
    }
}

