/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.client.model.animations.CrushingAnimation;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.block.entity.CrushableBlockEntity;
import com.idark.valoria.registries.block.types.CrushableBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.interfaces.ICustomAnimationItem;
import pro.komaru.tridot.api.render.animation.ItemAnimation;

public class PickItem
extends Item
implements ICustomAnimationItem,
Vanishable {
    public static CrushingAnimation animation = new CrushingAnimation();
    @Deprecated
    public static final double MAX_BRUSH_DISTANCE = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;
    public float excavationSpeed;
    public float attackDamageIn;
    public float attackSpeedIn;
    private final Supplier<Multimap<Attribute, AttributeModifier>> attributeModifiers = Suppliers.memoize(this::createAttributes);

    public PickItem(Item.Properties pProperties, int attackDamageIn, float attackSpeedIn, int speed) {
        super(pProperties);
        this.attackDamageIn = attackDamageIn;
        this.attackSpeedIn = attackSpeedIn;
        this.excavationSpeed = speed;
    }

    private Multimap<Attribute, AttributeModifier> createAttributes() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeReg.EXCAVATION_SPEED.get()), (Object)new AttributeModifier(f_41375_, "Pick modifier", (double)this.excavationSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamageIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.attackSpeedIn, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers.get() : super.m_7167_(equipmentSlot);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        if (player != null && this.calculateHitResult((LivingEntity)player).m_6662_() == HitResult.Type.BLOCK) {
            player.m_6672_(pContext.m_43724_());
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemAnimation getAnimation(ItemStack stack) {
        return animation;
    }

    public int m_8105_(ItemStack pStack) {
        return 200;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pRemainingUseDuration >= 0 && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            HitResult hitresult = this.calculateHitResult(pLivingEntity);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    double speed;
                    int i = this.m_8105_(pStack) - pRemainingUseDuration + 1;
                    if ((double)i % (speed = player.m_21133_((Attribute)AttributeReg.EXCAVATION_SPEED.get())) == 5.0) {
                        CrushableBlockEntity blockEntity;
                        BlockEntity blockentity;
                        SoundEvent soundevent;
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = pLevel.m_8055_(blockpos);
                        HumanoidArm humanoidarm = pLivingEntity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                        this.spawnDustParticles(pLevel, blockhitresult, blockstate, pLivingEntity.m_20252_(0.0f), humanoidarm);
                        Block pBlock = blockstate.m_60734_();
                        if (pBlock instanceof CrushableBlock) {
                            CrushableBlock block = (CrushableBlock)pBlock;
                            soundevent = block.getCrushSound();
                        } else {
                            soundevent = SoundEvents.f_276624_;
                        }
                        pLevel.m_247517_(player, blockpos, soundevent, SoundSource.BLOCKS);
                        if (!pLevel.m_5776_() && (blockentity = pLevel.m_7702_(blockpos)) instanceof CrushableBlockEntity && (blockEntity = (CrushableBlockEntity)blockentity).crushing(pLevel.m_46467_(), player, blockhitresult.m_82434_())) {
                            EquipmentSlot equipmentslot = pStack.equals(player.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                            pStack.m_41622_(1, pLivingEntity, p_279044_ -> p_279044_.m_21166_(equipmentslot));
                        }
                    }
                    return;
                }
            }
            pLivingEntity.m_21253_();
        } else {
            pLivingEntity.m_21253_();
        }
    }

    private HitResult calculateHitResult(LivingEntity pEntity) {
        return ProjectileUtil.m_278180_((Entity)pEntity, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)MAX_BRUSH_DISTANCE);
    }

    public void spawnDustParticles(Level pLevel, BlockHitResult pHitResult, BlockState pState, Vec3 pPos, HumanoidArm pArm) {
        int i = pArm == HumanoidArm.RIGHT ? 1 : -1;
        int j = pLevel.m_213780_().m_216339_(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.f_123794_, pState);
        Direction direction = pHitResult.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(pPos, direction);
        Vec3 vec3 = pHitResult.m_82450_();
        for (int k = 0; k < j; ++k) {
            pLevel.m_7106_((ParticleOptions)blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * pLevel.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * pLevel.m_213780_().m_188500_());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        public static DustParticlesDelta fromDirection(Vec3 pPos, Direction pDirection) {
            return switch (pDirection) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(pPos.m_7094_(), 0.0, -pPos.m_7096_());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
            };
        }
    }
}

